/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.bukkit;

import com.sk89q.worldedit.util.TreeGenerator;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Furnace;
import org.bukkit.block.NoteBlock;
import org.bukkit.block.Sign;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingSand;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Painting;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import wecui.vendor.com.sk89q.worldedit.BiomeType;
import wecui.vendor.com.sk89q.worldedit.BlockVector2D;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.EntityType;
import wecui.vendor.com.sk89q.worldedit.LocalEntity;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.Vector2D;
import wecui.vendor.com.sk89q.worldedit.WorldEdit;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseItemStack;
import wecui.vendor.com.sk89q.worldedit.blocks.ContainerBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.FurnaceBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.MobSpawnerBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.SignBlock;
import wecui.vendor.com.sk89q.worldedit.bukkit.BukkitUtil;
import wecui.vendor.com.sk89q.worldedit.bukkit.EditSessionBlockChangeDelegate;
import wecui.vendor.com.sk89q.worldedit.bukkit.entity.BukkitEntity;
import wecui.vendor.com.sk89q.worldedit.regions.Region;
import wecui.vendor.com.sk89q.worldedit.util.TreeGenerator;

public class BukkitWorld
extends LocalWorld {
    private World world;
    private static final EnumMap<TreeGenerator.TreeType, TreeType> treeTypeMapping = new EnumMap(TreeGenerator.TreeType.class);
    private static final Map<Integer, Effect> effects;

    public BukkitWorld(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public String getName() {
        return this.world.getName();
    }

    @Override
    public boolean setBlockType(Vector pt2, int type) {
        return this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ()).setTypeId(type);
    }

    @Override
    public boolean setBlockTypeFast(Vector pt2, int type) {
        return this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ()).setTypeId(type, false);
    }

    @Override
    public boolean setTypeIdAndData(Vector pt2, int type, int data) {
        return this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ()).setTypeIdAndData(type, (byte)data, true);
    }

    @Override
    public boolean setTypeIdAndDataFast(Vector pt2, int type, int data) {
        return this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ()).setTypeIdAndData(type, (byte)data, false);
    }

    @Override
    public int getBlockType(Vector pt2) {
        return this.world.getBlockTypeIdAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ());
    }

    @Override
    public void setBlockData(Vector pt2, int data) {
        this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ()).setData((byte)data);
    }

    @Override
    public void setBlockDataFast(Vector pt2, int data) {
        this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ()).setData((byte)data, false);
    }

    @Override
    public int getBlockData(Vector pt2) {
        return this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ()).getData();
    }

    @Override
    public int getBlockLightLevel(Vector pt2) {
        return this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ()).getLightLevel();
    }

    @Override
    public BiomeType getBiome(Vector2D pt2) {
        Biome bukkitBiome = this.world.getBiome(pt2.getBlockX(), pt2.getBlockZ());
        return new BiomeType(bukkitBiome.name());
    }

    @Override
    public void setBiome(Vector2D pt2, BiomeType biome) {
        Biome bukkitBiome;
        try {
            bukkitBiome = Biome.valueOf((String)biome.getName().toUpperCase());
        }
        catch (IllegalArgumentException e2) {
            return;
        }
        this.world.setBiome(pt2.getBlockX(), pt2.getBlockZ(), bukkitBiome);
    }

    @Override
    public boolean regenerate(Region region, EditSession editSession) {
        BaseBlock[] history = new BaseBlock[256 * (this.getMaxY() + 1)];
        for (Vector2D vector2D : region.getChunks()) {
            int index;
            Vector min = new Vector(vector2D.getBlockX() * 16, 0, vector2D.getBlockZ() * 16);
            for (int x2 = 0; x2 < 16; ++x2) {
                for (int y2 = 0; y2 < this.getMaxY() + 1; ++y2) {
                    for (int z2 = 0; z2 < 16; ++z2) {
                        Vector pt2 = min.add(x2, y2, z2);
                        index = y2 * 16 * 16 + z2 * 16 + x2;
                        history[index] = editSession.getBlock(pt2);
                    }
                }
            }
            try {
                this.world.regenerateChunk(vector2D.getBlockX(), vector2D.getBlockZ());
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
            for (int x2 = 0; x2 < 16; ++x2) {
                for (int y2 = 0; y2 < this.getMaxY() + 1; ++y2) {
                    for (int z2 = 0; z2 < 16; ++z2) {
                        Vector pt2 = min.add(x2, y2, z2);
                        index = y2 * 16 * 16 + z2 * 16 + x2;
                        if (!region.contains(pt2)) {
                            editSession.smartSetBlock(pt2, history[index]);
                            continue;
                        }
                        editSession.rememberChange(pt2, history[index], editSession.rawGetBlock(pt2));
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean copyToWorld(Vector pt2, BaseBlock block) {
        if (block instanceof SignBlock) {
            this.setSignText(pt2, ((SignBlock)block).getText());
            return true;
        }
        if (block instanceof FurnaceBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof Furnace)) {
                return false;
            }
            Furnace bukkit = (Furnace)state;
            FurnaceBlock we2 = (FurnaceBlock)block;
            bukkit.setBurnTime(we2.getBurnTime());
            bukkit.setCookTime(we2.getCookTime());
            return this.setContainerBlockContents(pt2, ((ContainerBlock)block).getItems());
        }
        if (block instanceof ContainerBlock) {
            return this.setContainerBlockContents(pt2, ((ContainerBlock)block).getItems());
        }
        if (block instanceof MobSpawnerBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof CreatureSpawner)) {
                return false;
            }
            CreatureSpawner bukkit = (CreatureSpawner)state;
            MobSpawnerBlock we3 = (MobSpawnerBlock)block;
            bukkit.setCreatureTypeByName(we3.getMobType());
            bukkit.setDelay((int)we3.getDelay());
            return true;
        }
        if (block instanceof wecui.vendor.com.sk89q.worldedit.blocks.NoteBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof NoteBlock)) {
                return false;
            }
            NoteBlock bukkit = (NoteBlock)state;
            wecui.vendor.com.sk89q.worldedit.blocks.NoteBlock we4 = (wecui.vendor.com.sk89q.worldedit.blocks.NoteBlock)block;
            bukkit.setRawNote(we4.getNote());
            return true;
        }
        return false;
    }

    @Override
    public boolean copyFromWorld(Vector pt2, BaseBlock block) {
        if (block instanceof SignBlock) {
            ((SignBlock)block).setText(this.getSignText(pt2));
            return true;
        }
        if (block instanceof FurnaceBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof Furnace)) {
                return false;
            }
            Furnace bukkit = (Furnace)state;
            FurnaceBlock we2 = (FurnaceBlock)block;
            we2.setBurnTime(bukkit.getBurnTime());
            we2.setCookTime(bukkit.getCookTime());
            ((ContainerBlock)block).setItems(this.getContainerBlockContents(pt2));
            return true;
        }
        if (block instanceof ContainerBlock) {
            ((ContainerBlock)block).setItems(this.getContainerBlockContents(pt2));
            return true;
        }
        if (block instanceof MobSpawnerBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof CreatureSpawner)) {
                return false;
            }
            CreatureSpawner bukkit = (CreatureSpawner)state;
            MobSpawnerBlock we3 = (MobSpawnerBlock)block;
            we3.setMobType(bukkit.getCreatureTypeName());
            we3.setDelay((short)bukkit.getDelay());
            return true;
        }
        if (block instanceof wecui.vendor.com.sk89q.worldedit.blocks.NoteBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof NoteBlock)) {
                return false;
            }
            NoteBlock bukkit = (NoteBlock)state;
            wecui.vendor.com.sk89q.worldedit.blocks.NoteBlock we4 = (wecui.vendor.com.sk89q.worldedit.blocks.NoteBlock)block;
            we4.setNote(bukkit.getRawNote());
        }
        return false;
    }

    private Inventory getBlockInventory(Chest chest) {
        try {
            return chest.getBlockInventory();
        }
        catch (Throwable t2) {
            if (chest.getInventory() instanceof DoubleChestInventory) {
                DoubleChestInventory inven = (DoubleChestInventory)chest.getInventory();
                if (inven.getLeftSide().getHolder().equals(chest)) {
                    return inven.getLeftSide();
                }
                if (inven.getRightSide().getHolder().equals(chest)) {
                    return inven.getRightSide();
                }
                return inven;
            }
            return chest.getInventory();
        }
    }

    @Override
    public boolean clearContainerBlockContents(Vector pt2) {
        Block block = this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ());
        if (block == null) {
            return false;
        }
        BlockState state = block.getState();
        if (!(state instanceof InventoryHolder)) {
            return false;
        }
        InventoryHolder chest = (InventoryHolder)state;
        Inventory inven = chest.getInventory();
        if (chest instanceof Chest) {
            inven = this.getBlockInventory((Chest)chest);
        }
        inven.clear();
        return true;
    }

    @Override
    @Deprecated
    public boolean generateTree(EditSession editSession, Vector pt2) {
        return this.generateTree(TreeGenerator.TreeType.TREE, editSession, pt2);
    }

    @Override
    @Deprecated
    public boolean generateBigTree(EditSession editSession, Vector pt2) {
        return this.generateTree(TreeGenerator.TreeType.BIG_TREE, editSession, pt2);
    }

    @Override
    @Deprecated
    public boolean generateBirchTree(EditSession editSession, Vector pt2) {
        return this.generateTree(TreeGenerator.TreeType.BIRCH, editSession, pt2);
    }

    @Override
    @Deprecated
    public boolean generateRedwoodTree(EditSession editSession, Vector pt2) {
        return this.generateTree(TreeGenerator.TreeType.REDWOOD, editSession, pt2);
    }

    @Override
    @Deprecated
    public boolean generateTallRedwoodTree(EditSession editSession, Vector pt2) {
        return this.generateTree(TreeGenerator.TreeType.TALL_REDWOOD, editSession, pt2);
    }

    public static TreeType toBukkitTreeType(TreeGenerator.TreeType type) {
        return treeTypeMapping.get((Object)type);
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, Vector pt2) {
        TreeType bukkitType = BukkitWorld.toBukkitTreeType(type);
        return type != null && this.world.generateTree(BukkitUtil.toLocation(this.world, pt2), bukkitType, (BlockChangeDelegate)new EditSessionBlockChangeDelegate(editSession));
    }

    @Override
    public void dropItem(Vector pt2, BaseItemStack item) {
        ItemStack bukkitItem = new ItemStack(item.getType(), item.getAmount(), item.getDamage());
        this.world.dropItemNaturally(BukkitUtil.toLocation(this.world, pt2), bukkitItem);
    }

    @Override
    public int killMobs(Vector origin, double radius, int flags) {
        boolean killPets = (flags & 1) != 0;
        boolean killNPCs = (flags & 2) != 0;
        boolean killAnimals = (flags & 4) != 0;
        boolean withLightning = (flags & 0x100000) != 0;
        boolean killGolems = (flags & 8) != 0;
        int num = 0;
        double radiusSq = radius * radius;
        Location bukkitOrigin = BukkitUtil.toLocation(this.world, origin);
        for (LivingEntity ent : this.world.getLivingEntities()) {
            if (ent instanceof HumanEntity || !killAnimals && ent instanceof Animals || !killPets && ent instanceof Tameable && ((Tameable)ent).isTamed()) continue;
            try {
                if (!killGolems && Class.forName("org.bukkit.entity.Golem").isAssignableFrom(ent.getClass())) {
                    continue;
                }
            }
            catch (ClassNotFoundException e2) {
                // empty catch block
            }
            try {
                if (!killNPCs && Class.forName("org.bukkit.entity.NPC").isAssignableFrom(ent.getClass())) {
                    continue;
                }
            }
            catch (ClassNotFoundException e3) {
                // empty catch block
            }
            if (!(radius < 0.0) && !(bukkitOrigin.distanceSquared(ent.getLocation()) <= radiusSq)) continue;
            if (withLightning) {
                this.world.strikeLightningEffect(ent.getLocation());
            }
            ent.remove();
            ++num;
        }
        return num;
    }

    @Override
    public int removeEntities(EntityType type, Vector origin, int radius) {
        int num = 0;
        double radiusSq = Math.pow(radius, 2.0);
        for (Entity ent : this.world.getEntities()) {
            if (radius != -1 && origin.distanceSq(BukkitUtil.toVector(ent.getLocation())) > radiusSq) continue;
            if (type == EntityType.ARROWS) {
                if (!(ent instanceof Arrow)) continue;
                ent.remove();
                ++num;
                continue;
            }
            if (type == EntityType.BOATS) {
                if (!(ent instanceof Boat)) continue;
                ent.remove();
                ++num;
                continue;
            }
            if (type == EntityType.ITEMS) {
                if (!(ent instanceof Item)) continue;
                ent.remove();
                ++num;
                continue;
            }
            if (type == EntityType.FALLING_BLOCKS) {
                if (!(ent instanceof FallingSand)) continue;
                ent.remove();
                ++num;
                continue;
            }
            if (type == EntityType.MINECARTS) {
                if (!(ent instanceof Minecart)) continue;
                ent.remove();
                ++num;
                continue;
            }
            if (type == EntityType.PAINTINGS) {
                if (!(ent instanceof Painting)) continue;
                ent.remove();
                ++num;
                continue;
            }
            if (type == EntityType.TNT) {
                if (!(ent instanceof TNTPrimed)) continue;
                ent.remove();
                ++num;
                continue;
            }
            if (type != EntityType.XP_ORBS || !(ent instanceof ExperienceOrb)) continue;
            ent.remove();
            ++num;
        }
        return num;
    }

    private boolean setSignText(Vector pt2, String[] text) {
        Block block = this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ());
        if (block == null) {
            return false;
        }
        BlockState state = block.getState();
        if (state == null || !(state instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)state;
        sign.setLine(0, text[0]);
        sign.setLine(1, text[1]);
        sign.setLine(2, text[2]);
        sign.setLine(3, text[3]);
        sign.update();
        return true;
    }

    private String[] getSignText(Vector pt2) {
        Block block = this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ());
        if (block == null) {
            return new String[]{"", "", "", ""};
        }
        BlockState state = block.getState();
        if (state == null || !(state instanceof Sign)) {
            return new String[]{"", "", "", ""};
        }
        Sign sign = (Sign)state;
        String line0 = sign.getLine(0);
        String line1 = sign.getLine(1);
        String line2 = sign.getLine(2);
        String line3 = sign.getLine(3);
        return new String[]{line0 != null ? line0 : "", line1 != null ? line1 : "", line2 != null ? line2 : "", line3 != null ? line3 : ""};
    }

    private BaseItemStack[] getContainerBlockContents(Vector pt2) {
        Block block = this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ());
        if (block == null) {
            return new BaseItemStack[0];
        }
        BlockState state = block.getState();
        if (!(state instanceof InventoryHolder)) {
            return new BaseItemStack[0];
        }
        InventoryHolder container = (InventoryHolder)state;
        Inventory inven = container.getInventory();
        if (container instanceof Chest) {
            inven = this.getBlockInventory((Chest)container);
        }
        int size = inven.getSize();
        BaseItemStack[] contents = new BaseItemStack[size];
        for (int i2 = 0; i2 < size; ++i2) {
            ItemStack bukkitStack = inven.getItem(i2);
            if (bukkitStack == null || bukkitStack.getTypeId() <= 0) continue;
            contents[i2] = new BaseItemStack(bukkitStack.getTypeId(), bukkitStack.getAmount(), bukkitStack.getDurability());
            try {
                for (Map.Entry entry : bukkitStack.getEnchantments().entrySet()) {
                    contents[i2].getEnchantments().put(((Enchantment)entry.getKey()).getId(), (Integer)entry.getValue());
                }
                continue;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return contents;
    }

    private boolean setContainerBlockContents(Vector pt2, BaseItemStack[] contents) {
        Block block = this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ());
        if (block == null) {
            return false;
        }
        BlockState state = block.getState();
        if (!(state instanceof InventoryHolder)) {
            return false;
        }
        InventoryHolder chest = (InventoryHolder)state;
        Inventory inven = chest.getInventory();
        if (chest instanceof Chest) {
            inven = this.getBlockInventory((Chest)chest);
        }
        int size = inven.getSize();
        for (int i2 = 0; i2 < size && i2 < contents.length; ++i2) {
            if (contents[i2] != null) {
                ItemStack toAdd = new ItemStack(contents[i2].getType(), contents[i2].getAmount(), contents[i2].getDamage());
                try {
                    for (Map.Entry<Integer, Integer> entry : contents[i2].getEnchantments().entrySet()) {
                        toAdd.addEnchantment(Enchantment.getById((int)entry.getKey()), entry.getValue().intValue());
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                inven.setItem(i2, toAdd);
                continue;
            }
            inven.setItem(i2, null);
        }
        return true;
    }

    @Override
    public boolean isValidBlockType(int type) {
        return type <= 255 && Material.getMaterial((int)type) != null;
    }

    @Override
    public void checkLoadedChunk(Vector pt2) {
        if (!this.world.isChunkLoaded(pt2.getBlockX() >> 4, pt2.getBlockZ() >> 4)) {
            this.world.loadChunk(pt2.getBlockX() >> 4, pt2.getBlockZ() >> 4);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof BukkitWorld)) {
            return false;
        }
        return ((BukkitWorld)other).world.equals(this.world);
    }

    @Override
    public int hashCode() {
        return this.world.hashCode();
    }

    @Override
    public int getMaxY() {
        return this.world.getMaxHeight() - 1;
    }

    @Override
    public void fixAfterFastMode(Iterable<com.sk89q.worldedit.BlockVector2D> chunks) {
        for (BlockVector2D blockVector2D : chunks) {
            this.world.refreshChunk(blockVector2D.getBlockX(), blockVector2D.getBlockZ());
        }
    }

    @Override
    public boolean playEffect(Vector position, int type, int data) {
        Effect effect = effects.get(type);
        if (effect == null) {
            return false;
        }
        this.world.playEffect(BukkitUtil.toLocation(this.world, position), effect, data);
        return true;
    }

    @Override
    public void simulateBlockMine(Vector pt2) {
        this.world.getBlockAt(pt2.getBlockX(), pt2.getBlockY(), pt2.getBlockZ()).breakNaturally();
    }

    @Override
    public LocalEntity[] getEntities(Region region) {
        ArrayList<BukkitEntity> entities = new ArrayList<BukkitEntity>();
        for (Vector2D vector2D : region.getChunks()) {
            Entity[] ents;
            if (!this.world.isChunkLoaded(vector2D.getBlockX(), vector2D.getBlockZ())) continue;
            for (Entity ent : ents = this.world.getChunkAt(vector2D.getBlockX(), vector2D.getBlockZ()).getEntities()) {
                if (!region.contains(BukkitUtil.toVector(ent.getLocation()))) continue;
                entities.add(BukkitUtil.toLocalEntity(ent));
            }
        }
        return entities.toArray(new BukkitEntity[entities.size()]);
    }

    @Override
    public int killEntities(LocalEntity ... entities) {
        int amount = 0;
        HashSet<UUID> toKill = new HashSet<UUID>();
        for (LocalEntity entity : entities) {
            toKill.add(((BukkitEntity)entity).getEntityId());
        }
        for (Entity entity : this.world.getEntities()) {
            if (!toKill.contains(entity.getUniqueId())) continue;
            entity.remove();
            ++amount;
        }
        return amount;
    }

    static {
        treeTypeMapping.put((TreeGenerator.TreeType)TreeGenerator.TreeType.SWAMP, TreeType.TREE);
        treeTypeMapping.put((TreeGenerator.TreeType)TreeGenerator.TreeType.JUNGLE_BUSH, TreeType.TREE);
        try {
            treeTypeMapping.put((TreeGenerator.TreeType)TreeGenerator.TreeType.SHORT_JUNGLE, TreeType.valueOf((String)"SMALL_JUNGLE"));
        }
        catch (IllegalArgumentException e2) {
            treeTypeMapping.put((TreeGenerator.TreeType)TreeGenerator.TreeType.SHORT_JUNGLE, TreeType.TREE);
        }
        for (TreeGenerator.TreeType treeType : TreeGenerator.TreeType.values()) {
            try {
                TreeType bukkitType = TreeType.valueOf((String)treeType.name());
                treeTypeMapping.put((TreeGenerator.TreeType)treeType, bukkitType);
            }
            catch (IllegalArgumentException e3) {
                // empty catch block
            }
        }
        treeTypeMapping.put((TreeGenerator.TreeType)TreeGenerator.TreeType.RANDOM, TreeType.BROWN_MUSHROOM);
        treeTypeMapping.put((TreeGenerator.TreeType)TreeGenerator.TreeType.RANDOM_REDWOOD, TreeType.REDWOOD);
        treeTypeMapping.put((TreeGenerator.TreeType)TreeGenerator.TreeType.PINE, TreeType.REDWOOD);
        for (TreeGenerator.TreeType treeType : TreeGenerator.TreeType.values()) {
            if (treeTypeMapping.get((Object)treeType) != null) continue;
            WorldEdit.logger.severe("No TreeType mapping for TreeGenerator.TreeType." + (Object)((Object)treeType));
        }
        effects = new HashMap<Integer, Effect>();
        for (TreeGenerator.TreeType treeType : Effect.values()) {
            effects.put(treeType.getId(), (Effect)treeType);
        }
    }
}

