/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.bukkit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import wecui.vendor.com.sk89q.util.StringUtil;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.WorldEdit;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.bukkit.BukkitPlayer;
import wecui.vendor.com.sk89q.worldedit.bukkit.WorldEditPlugin;

public class WorldEditListener
implements Listener {
    private WorldEditPlugin plugin;
    private boolean ignoreLeftClickAir = false;
    private static final Pattern cuipattern = Pattern.compile("u00a74u00a75u00a73u00a74([^\\|]*)\\|?(.*)");

    public WorldEditListener(WorldEditPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (player.isOnline()) {
                    WorldEditListener.this.plugin.wrapPlayer(player).dispatchCUIHandshake();
                }
            }
        }, 40L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.getWorldEdit().markExpire(this.plugin.wrapPlayer(event.getPlayer()));
        this.plugin.setPluginChannelCUI(event.getPlayer().getName(), false);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String newMessage;
        String[] split = event.getMessage().split(" ");
        if (split.length > 0) {
            split = this.plugin.getWorldEdit().commandDetection(split);
            split[0] = "/" + split[0];
        }
        if (!(newMessage = StringUtil.joinString(split, " ")).equals(event.getMessage())) {
            event.setMessage(newMessage);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                if (event.getMessage().length() > 0) {
                    this.plugin.getServer().dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1));
                }
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        BukkitPlayer player = this.plugin.wrapPlayer(event.getPlayer());
        LocalWorld world = ((LocalPlayer)player).getWorld();
        WorldEdit we2 = this.plugin.getWorldEdit();
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_BLOCK) {
            int taskId;
            Block clickedBlock = event.getClickedBlock();
            WorldVector pos = new WorldVector(world, clickedBlock.getX(), clickedBlock.getY(), clickedBlock.getZ());
            if (we2.handleBlockLeftClick(player, pos)) {
                event.setCancelled(true);
            }
            if (we2.handleArmSwing(player)) {
                event.setCancelled(true);
            }
            if (!this.ignoreLeftClickAir && (taskId = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    WorldEditListener.this.ignoreLeftClickAir = false;
                }
            }, 2L)) != -1) {
                this.ignoreLeftClickAir = true;
            }
        } else if (action == Action.LEFT_CLICK_AIR) {
            if (this.ignoreLeftClickAir) {
                return;
            }
            if (we2.handleArmSwing(player)) {
                event.setCancelled(true);
            }
        } else if (action == Action.RIGHT_CLICK_BLOCK) {
            Block clickedBlock = event.getClickedBlock();
            WorldVector pos = new WorldVector(world, clickedBlock.getX(), clickedBlock.getY(), clickedBlock.getZ());
            if (we2.handleBlockRightClick(player, pos)) {
                event.setCancelled(true);
            }
            if (we2.handleRightClick(player)) {
                event.setCancelled(true);
            }
        } else if (action == Action.RIGHT_CLICK_AIR && we2.handleRightClick(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChat(PlayerChatEvent event) {
        Matcher matcher = cuipattern.matcher(event.getMessage());
        if (matcher.find()) {
            String type = matcher.group(1);
            String args = matcher.group(2);
            if (type.equals("v")) {
                try {
                    this.plugin.getSession(event.getPlayer()).setCUIVersion(Integer.parseInt(args));
                    event.setCancelled(true);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
        }
    }
}

