/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.bukkit.selections;

import org.bukkit.Location;
import org.bukkit.World;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.bukkit.BukkitUtil;
import wecui.vendor.com.sk89q.worldedit.bukkit.selections.RegionSelection;
import wecui.vendor.com.sk89q.worldedit.regions.CuboidRegion;
import wecui.vendor.com.sk89q.worldedit.regions.CuboidRegionSelector;
import wecui.vendor.com.sk89q.worldedit.regions.RegionSelector;

public class CuboidSelection
extends RegionSelection {
    protected CuboidRegion cuboid;

    public CuboidSelection(World world, Location pt1, Location pt2) {
        this(world, BukkitUtil.toVector(pt1), BukkitUtil.toVector(pt2));
    }

    public CuboidSelection(World world, Vector pt1, Vector pt2) {
        super(world);
        if (pt1 == null) {
            throw new IllegalArgumentException("Null point 1 not permitted");
        }
        if (pt2 == null) {
            throw new IllegalArgumentException("Null point 2 not permitted");
        }
        CuboidRegionSelector sel = new CuboidRegionSelector(BukkitUtil.getLocalWorld(world));
        sel.selectPrimary(pt1);
        sel.selectSecondary(pt2);
        this.cuboid = sel.getIncompleteRegion();
        this.setRegionSelector(sel);
        this.setRegion(this.cuboid);
    }

    public CuboidSelection(World world, RegionSelector sel, CuboidRegion region) {
        super(world, sel, region);
        this.cuboid = region;
    }
}

