/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.commands;

import wecui.vendor.com.sk89q.minecraft.util.commands.Command;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandContext;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandPermissions;
import wecui.vendor.com.sk89q.minecraft.util.commands.Logging;
import wecui.vendor.com.sk89q.minecraft.util.commands.NestedCommand;
import wecui.vendor.com.sk89q.worldedit.CuboidClipboard;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalEntity;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.WorldEdit;
import wecui.vendor.com.sk89q.worldedit.WorldEditException;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.commands.SchematicCommands;
import wecui.vendor.com.sk89q.worldedit.regions.Region;

public class ClipboardCommands {
    private final WorldEdit we;

    public ClipboardCommands(WorldEdit we2) {
        this.we = we2;
    }

    @Command(aliases={"/copy"}, flags="e", desc="Copy the selection to the clipboard", help="Copy the selection to the clipboard\nFlags:\n  -e controls whether entities are copied\nWARNING: Pasting entities cannot yet be undone!", min=0, max=0)
    @CommandPermissions(value={"worldedit.clipboard.copy"})
    public void copy(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Region region = session.getSelection(player.getWorld());
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        Vector pos = session.getPlacementPosition(player);
        CuboidClipboard clipboard = new CuboidClipboard(max.subtract(min).add(new Vector(1, 1, 1)), min, min.subtract(pos));
        clipboard.copy(editSession);
        if (args.hasFlag('e')) {
            for (LocalEntity entity : player.getWorld().getEntities(region)) {
                clipboard.storeEntity(entity);
            }
        }
        session.setClipboard(clipboard);
        player.print("Block(s) copied.");
    }

    @Command(aliases={"/cut"}, usage="[leave-id]", desc="Cut the selection to the clipboard", help="Copy the selection to the clipboard\nFlags:\n  -e controls whether entities are copied\nWARNING: Cutting and pasting entities cannot yet be undone!", flags="e", min=0, max=1)
    @CommandPermissions(value={"worldedit.clipboard.cut"})
    @Logging(value=Logging.LogMode.REGION)
    public void cut(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        BaseBlock block = new BaseBlock(0);
        LocalWorld world = player.getWorld();
        if (args.argsLength() > 0) {
            block = this.we.getBlock(player, args.getString(0));
        }
        Region region = session.getSelection(world);
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        Vector pos = session.getPlacementPosition(player);
        CuboidClipboard clipboard = new CuboidClipboard(max.subtract(min).add(new Vector(1, 1, 1)), min, min.subtract(pos));
        clipboard.copy(editSession);
        if (args.hasFlag('e')) {
            LocalEntity[] entities;
            for (LocalEntity entity : entities = world.getEntities(region)) {
                clipboard.storeEntity(entity);
            }
            world.killEntities(entities);
        }
        session.setClipboard(clipboard);
        editSession.setBlocks(session.getSelection(world), block);
        player.print("Block(s) cut.");
    }

    @Command(aliases={"/paste"}, usage="", flags="ao", desc="Paste the clipboard's contents", help="Pastes the clipboard's contents.\nFlags:\n  -a skips air blocks\n  -o pastes at the original position", min=0, max=0)
    @CommandPermissions(value={"worldedit.clipboard.paste"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void paste(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        boolean atOrigin = args.hasFlag('o');
        boolean pasteNoAir = args.hasFlag('a');
        if (atOrigin) {
            Vector pos = session.getClipboard().getOrigin();
            session.getClipboard().place(editSession, pos, pasteNoAir);
            session.getClipboard().pasteEntities(pos);
            player.findFreePosition();
            player.print("Pasted to copy origin. Undo with //undo");
        } else {
            Vector pos = session.getPlacementPosition(player);
            session.getClipboard().paste(editSession, pos, pasteNoAir, true);
            player.findFreePosition();
            player.print("Pasted relative to you. Undo with //undo");
        }
    }

    @Command(aliases={"/rotate"}, usage="<angle-in-degrees>", desc="Rotate the contents of the clipboard", min=1, max=1)
    @CommandPermissions(value={"worldedit.clipboard.rotate"})
    public void rotate(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int angle = args.getInteger(0);
        if (angle % 90 == 0) {
            CuboidClipboard clipboard = session.getClipboard();
            clipboard.rotate2D(angle);
            player.print("Clipboard rotated by " + angle + " degrees.");
        } else {
            player.printError("Angles must be divisible by 90 degrees.");
        }
    }

    @Command(aliases={"/flip"}, usage="[dir]", flags="p", desc="Flip the contents of the clipboard.", help="Flips the contents of the clipboard.\nThe -p flag flips the selection around the player,\ninstead of the selections center.", min=0, max=1)
    @CommandPermissions(value={"worldedit.clipboard.flip"})
    public void flip(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        CuboidClipboard.FlipDirection dir = this.we.getFlipDirection(player, args.argsLength() > 0 ? args.getString(0).toLowerCase() : "me");
        CuboidClipboard clipboard = session.getClipboard();
        clipboard.flip(dir, args.hasFlag('p'));
        player.print("Clipboard flipped.");
    }

    @Command(aliases={"/load"}, usage="<filename>", desc="Load a schematic into your clipboard", min=0, max=1)
    @Deprecated
    @CommandPermissions(value={"worldedit.clipboard.load"})
    public void load(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.printError("This command is no longer used. See //schematic load.");
    }

    @Command(aliases={"/save"}, usage="<filename>", desc="Save a schematic into your clipboard", min=0, max=1)
    @Deprecated
    @CommandPermissions(value={"worldedit.clipboard.save"})
    public void save(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.printError("This command is no longer used. See //schematic save.");
    }

    @Command(aliases={"/schematic", "/schem"}, desc="Schematic-related commands")
    @NestedCommand(value={SchematicCommands.class})
    public void schematic() {
    }

    @Command(aliases={"clearclipboard"}, usage="", desc="Clear your clipboard", min=0, max=0)
    @CommandPermissions(value={"worldedit.clipboard.clear"})
    public void clearClipboard(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setClipboard(null);
        player.print("Clipboard cleared.");
    }
}

