/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.commands;

import wecui.vendor.com.sk89q.minecraft.util.commands.Command;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandContext;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandPermissions;
import wecui.vendor.com.sk89q.minecraft.util.commands.Logging;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.WorldEdit;
import wecui.vendor.com.sk89q.worldedit.WorldEditException;
import wecui.vendor.com.sk89q.worldedit.expression.ExpressionException;
import wecui.vendor.com.sk89q.worldedit.patterns.Pattern;
import wecui.vendor.com.sk89q.worldedit.regions.Region;
import wecui.vendor.com.sk89q.worldedit.util.TreeGenerator;

public class GenerationCommands {
    private final WorldEdit we;

    public GenerationCommands(WorldEdit we2) {
        this.we = we2;
    }

    @Command(aliases={"/hcyl"}, usage="<block> <radius>[,<radius>] [height]", desc="Generates a hollow cylinder.", help="Generates a hollow cylinder.\nBy specifying 2 radii, separated by a comma,\nyou can generate elliptical cylinders.\nThe 1st radius is north/south, the 2nd radius is east/west.", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.cylinder"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void hcyl(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radiusX;
        double radiusZ;
        Pattern block = this.we.getBlockPattern(player, args.getString(0));
        String[] radiuses = args.getString(1).split(",");
        switch (radiuses.length) {
            case 1: {
                radiusX = radiusZ = Math.max(1.0, Double.parseDouble(radiuses[0]));
                break;
            }
            case 2: {
                radiusX = Math.max(1.0, Double.parseDouble(radiuses[0]));
                radiusZ = Math.max(1.0, Double.parseDouble(radiuses[1]));
                break;
            }
            default: {
                player.printError("You must either specify 1 or 2 radius values.");
                return;
            }
        }
        int height = args.argsLength() > 2 ? args.getInteger(2) : 1;
        Vector pos = session.getPlacementPosition(player);
        int affected = editSession.makeCylinder(pos, block, radiusX, radiusZ, height, false);
        player.print(affected + " block(s) have been created.");
    }

    @Command(aliases={"/cyl"}, usage="<block> <radius>[,<radius>] [height]", desc="Generates a cylinder.", help="Generates a cylinder.\nBy specifying 2 radii, separated by a comma,\nyou can generate elliptical cylinders.\nThe 1st radius is north/south, the 2nd radius is east/west.", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.cylinder"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void cyl(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radiusX;
        double radiusZ;
        Pattern block = this.we.getBlockPattern(player, args.getString(0));
        String[] radiuses = args.getString(1).split(",");
        switch (radiuses.length) {
            case 1: {
                radiusX = radiusZ = Math.max(1.0, Double.parseDouble(radiuses[0]));
                break;
            }
            case 2: {
                radiusX = Math.max(1.0, Double.parseDouble(radiuses[0]));
                radiusZ = Math.max(1.0, Double.parseDouble(radiuses[1]));
                break;
            }
            default: {
                player.printError("You must either specify 1 or 2 radius values.");
                return;
            }
        }
        int height = args.argsLength() > 2 ? args.getInteger(2) : 1;
        Vector pos = session.getPlacementPosition(player);
        int affected = editSession.makeCylinder(pos, block, radiusX, radiusZ, height, true);
        player.print(affected + " block(s) have been created.");
    }

    @Command(aliases={"/hsphere"}, usage="<block> <radius>[,<radius>,<radius>] [raised?]", desc="Generates a hollow sphere.", help="Generates a hollow sphere.\nBy specifying 3 radii, separated by commas,\nyou can generate an ellipsoid. The order of the ellipsoid radii\nis north/south, up/down, east/west.", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.sphere"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void hsphere(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radiusX;
        double radiusY;
        double radiusZ;
        Pattern block = this.we.getBlockPattern(player, args.getString(0));
        String[] radiuses = args.getString(1).split(",");
        switch (radiuses.length) {
            case 1: {
                radiusY = radiusZ = Math.max(1.0, Double.parseDouble(radiuses[0]));
                radiusX = radiusZ;
                break;
            }
            case 3: {
                radiusX = Math.max(1.0, Double.parseDouble(radiuses[0]));
                radiusY = Math.max(1.0, Double.parseDouble(radiuses[1]));
                radiusZ = Math.max(1.0, Double.parseDouble(radiuses[2]));
                break;
            }
            default: {
                player.printError("You must either specify 1 or 3 radius values.");
                return;
            }
        }
        boolean raised = args.argsLength() > 2 ? args.getString(2).equalsIgnoreCase("true") || args.getString(2).equalsIgnoreCase("yes") : false;
        Vector pos = session.getPlacementPosition(player);
        if (raised) {
            pos = pos.add(0.0, radiusY, 0.0);
        }
        int affected = editSession.makeSphere(pos, block, radiusX, radiusY, radiusZ, false);
        player.findFreePosition();
        player.print(affected + " block(s) have been created.");
    }

    @Command(aliases={"/sphere"}, usage="<block> <radius>[,<radius>,<radius>] [raised?]", desc="Generates a filled sphere.", help="Generates a filled sphere.\nBy specifying 3 radii, separated by commas,\nyou can generate an ellipsoid. The order of the ellipsoid radii\nis north/south, up/down, east/west.", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.sphere"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void sphere(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radiusX;
        double radiusY;
        double radiusZ;
        Pattern block = this.we.getBlockPattern(player, args.getString(0));
        String[] radiuses = args.getString(1).split(",");
        switch (radiuses.length) {
            case 1: {
                radiusY = radiusZ = Math.max(1.0, Double.parseDouble(radiuses[0]));
                radiusX = radiusZ;
                break;
            }
            case 3: {
                radiusX = Math.max(1.0, Double.parseDouble(radiuses[0]));
                radiusY = Math.max(1.0, Double.parseDouble(radiuses[1]));
                radiusZ = Math.max(1.0, Double.parseDouble(radiuses[2]));
                break;
            }
            default: {
                player.printError("You must either specify 1 or 3 radius values.");
                return;
            }
        }
        boolean raised = args.argsLength() > 2 ? args.getString(2).equalsIgnoreCase("true") || args.getString(2).equalsIgnoreCase("yes") : false;
        Vector pos = session.getPlacementPosition(player);
        if (raised) {
            pos = pos.add(0.0, radiusY, 0.0);
        }
        int affected = editSession.makeSphere(pos, block, radiusX, radiusY, radiusZ, true);
        player.findFreePosition();
        player.print(affected + " block(s) have been created.");
    }

    @Command(aliases={"forestgen"}, usage="[size] [type] [density]", desc="Generate a forest", min=0, max=3)
    @CommandPermissions(value={"worldedit.generation.forest"})
    @Logging(value=Logging.LogMode.POSITION)
    public void forestGen(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double density;
        TreeGenerator.TreeType type;
        int size = args.argsLength() > 0 ? Math.max(1, args.getInteger(0)) : 10;
        type = args.argsLength() > 1 ? (type = TreeGenerator.lookup(args.getString(1))) : TreeGenerator.TreeType.TREE;
        double d2 = density = args.argsLength() > 2 ? args.getDouble(2) / 100.0 : 0.05;
        if (type == null) {
            player.printError("Tree type '" + args.getString(1) + "' is unknown.");
            return;
        }
        int affected = editSession.makeForest(player.getPosition(), size, density, new TreeGenerator(type));
        player.print(affected + " trees created.");
    }

    @Command(aliases={"pumpkins"}, usage="[size]", desc="Generate pumpkin patches", min=0, max=1)
    @CommandPermissions(value={"worldedit.generation.pumpkins"})
    @Logging(value=Logging.LogMode.POSITION)
    public void pumpkins(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int size = args.argsLength() > 0 ? Math.max(1, args.getInteger(0)) : 10;
        int affected = editSession.makePumpkinPatches(player.getPosition(), size);
        player.print(affected + " pumpkin patches created.");
    }

    @Command(aliases={"/pyramid"}, usage="<block> <size>", desc="Generate a filled pyramid", min=2, max=2)
    @CommandPermissions(value={"worldedit.generation.pyramid"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void pyramid(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern block = this.we.getBlockPattern(player, args.getString(0));
        int size = Math.max(1, args.getInteger(1));
        Vector pos = session.getPlacementPosition(player);
        int affected = editSession.makePyramid(pos, block, size, true);
        player.findFreePosition();
        player.print(affected + " block(s) have been created.");
    }

    @Command(aliases={"/hpyramid"}, usage="<block> <size>", desc="Generate a hollow pyramid", min=2, max=2)
    @CommandPermissions(value={"worldedit.generation.pyramid"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void hpyramid(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern block = this.we.getBlockPattern(player, args.getString(0));
        int size = Math.max(1, args.getInteger(1));
        Vector pos = session.getPlacementPosition(player);
        int affected = editSession.makePyramid(pos, block, size, false);
        player.findFreePosition();
        player.print(affected + " block(s) have been created.");
    }

    @Command(aliases={"/generate", "/gen", "/g"}, usage="<block> <expression>", desc="Generates a shape according to a formula.", help="Generates a shape according to a formula that is expected to\nreturn positive numbers (true) if the point is inside the shape\nOptionally set type/data to the desired block.\nFlags:\n  -h to generate a hollow shape\n  -r to use raw minecraft coordinates\n  -o is like -r, except offset from placement.\nIf neither -r nor -o is given, the selection is mapped to -1..1\nSee also tinyurl.com/wesyntax.", flags="hro", min=1, max=-1)
    @CommandPermissions(value={"worldedit.generation.shape"})
    @Logging(value=Logging.LogMode.ALL)
    public void generate(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Vector unit;
        Vector zero;
        Pattern pattern = this.we.getBlockPattern(player, args.getString(0));
        Region region = session.getSelection(player.getWorld());
        boolean hollow = args.hasFlag('h');
        String expression = args.getJoinedStrings(1);
        if (args.hasFlag('r')) {
            zero = new Vector(0, 0, 0);
            unit = new Vector(1, 1, 1);
        } else if (args.hasFlag('o')) {
            zero = session.getPlacementPosition(player);
            unit = new Vector(1, 1, 1);
        } else {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            unit = max.subtract(zero = max.add(min).multiply(0.5));
            if (unit.getX() == 0.0) {
                unit = unit.setX(1.0);
            }
            if (unit.getY() == 0.0) {
                unit = unit.setY(1.0);
            }
            if (unit.getZ() == 0.0) {
                unit = unit.setZ(1.0);
            }
        }
        try {
            int affected = editSession.makeShape(region, zero, unit, pattern, expression, hollow);
            player.findFreePosition();
            player.print(affected + " block(s) have been created.");
        }
        catch (ExpressionException e2) {
            player.printError(e2.getMessage());
        }
    }
}

