/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.commands;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import wecui.vendor.com.sk89q.minecraft.util.commands.Command;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandContext;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandPermissions;
import wecui.vendor.com.sk89q.minecraft.util.commands.NestedCommand;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalConfiguration;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.WorldEdit;
import wecui.vendor.com.sk89q.worldedit.WorldEditException;
import wecui.vendor.com.sk89q.worldedit.commands.SnapshotCommands;
import wecui.vendor.com.sk89q.worldedit.data.ChunkStore;
import wecui.vendor.com.sk89q.worldedit.data.DataException;
import wecui.vendor.com.sk89q.worldedit.data.MissingWorldException;
import wecui.vendor.com.sk89q.worldedit.regions.Region;
import wecui.vendor.com.sk89q.worldedit.snapshots.InvalidSnapshotException;
import wecui.vendor.com.sk89q.worldedit.snapshots.Snapshot;
import wecui.vendor.com.sk89q.worldedit.snapshots.SnapshotRestore;

public class SnapshotUtilCommands {
    private static final Logger logger = Logger.getLogger("Minecraft.WorldEdit");
    private final WorldEdit we;

    public SnapshotUtilCommands(WorldEdit we2) {
        this.we = we2;
    }

    @Command(aliases={"snapshot", "snap"}, desc="Snapshot commands")
    @NestedCommand(value={SnapshotCommands.class})
    public void snapshot(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(aliases={"restore", "/restore"}, usage="[snapshot]", desc="Restore the selection from a snapshot", min=0, max=1)
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public void restore(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Snapshot snapshot;
        Region region;
        block24: {
            LocalConfiguration config = this.we.getConfiguration();
            if (config.snapshotRepo == null) {
                player.printError("Snapshot/backup restore is not configured.");
                return;
            }
            region = session.getSelection(player.getWorld());
            if (args.argsLength() > 0) {
                try {
                    snapshot = config.snapshotRepo.getSnapshot(args.getString(0));
                }
                catch (InvalidSnapshotException e2) {
                    player.printError("That snapshot does not exist or is not available.");
                    return;
                }
            } else {
                snapshot = session.getSnapshot();
            }
            if (snapshot == null) {
                try {
                    snapshot = config.snapshotRepo.getDefaultSnapshot(player.getWorld().getName());
                    if (snapshot != null) break block24;
                    player.printError("No snapshots were found. See console for details.");
                    File dir = config.snapshotRepo.getDirectory();
                    try {
                        logger.info("WorldEdit found no snapshots: looked in: " + dir.getCanonicalPath());
                    }
                    catch (IOException e3) {
                        logger.info("WorldEdit found no snapshots: looked in (NON-RESOLVABLE PATH - does it exist?): " + dir.getPath());
                    }
                    return;
                }
                catch (MissingWorldException ex2) {
                    player.printError("No snapshots were found for this world.");
                    return;
                }
            }
        }
        ChunkStore chunkStore = null;
        try {
            chunkStore = snapshot.getChunkStore();
            player.print("Snapshot '" + snapshot.getName() + "' loaded; now restoring...");
        }
        catch (DataException e4) {
            player.printError("Failed to load snapshot: " + e4.getMessage());
            return;
        }
        catch (IOException e5) {
            player.printError("Failed to load snapshot: " + e5.getMessage());
            return;
        }
        try {
            SnapshotRestore restore = new SnapshotRestore(chunkStore, region);
            restore.restore(editSession);
            if (restore.hadTotalFailure()) {
                String error = restore.getLastErrorMessage();
                if (error != null) {
                    player.printError("Errors prevented any blocks from being restored.");
                    player.printError("Last error: " + error);
                } else {
                    player.printError("No chunks could be loaded. (Bad archive?)");
                }
            } else {
                player.print(String.format("Restored; %d missing chunks and %d other errors.", restore.getMissingChunks().size(), restore.getErrorChunks().size()));
            }
        }
        finally {
            try {
                chunkStore.close();
            }
            catch (IOException e6) {}
        }
    }
}

