/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.commands;

import wecui.vendor.com.sk89q.minecraft.util.commands.Command;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandContext;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandPermissions;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalConfiguration;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.WorldEdit;
import wecui.vendor.com.sk89q.worldedit.WorldEditException;
import wecui.vendor.com.sk89q.worldedit.tools.AreaPickaxe;
import wecui.vendor.com.sk89q.worldedit.tools.RecursivePickaxe;
import wecui.vendor.com.sk89q.worldedit.tools.SinglePickaxe;

public class SuperPickaxeCommands {
    private final WorldEdit we;

    public SuperPickaxeCommands(WorldEdit we2) {
        this.we = we2;
    }

    @Command(aliases={"single"}, usage="", desc="Enable the single block super pickaxe mode", min=0, max=0)
    @CommandPermissions(value={"worldedit.superpickaxe"})
    public void single(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setSuperPickaxe(new SinglePickaxe());
        session.enableSuperPickAxe();
        player.print("Mode changed. Left click with a pickaxe. // to disable.");
    }

    @Command(aliases={"area"}, usage="<radius>", desc="Enable the area super pickaxe pickaxe mode", min=1, max=1)
    @CommandPermissions(value={"worldedit.superpickaxe.area"})
    public void area(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        int range = args.getInteger(0);
        if (range > config.maxSuperPickaxeSize) {
            player.printError("Maximum range: " + config.maxSuperPickaxeSize);
            return;
        }
        session.setSuperPickaxe(new AreaPickaxe(range));
        session.enableSuperPickAxe();
        player.print("Mode changed. Left click with a pickaxe. // to disable.");
    }

    @Command(aliases={"recur", "recursive"}, usage="<radius>", desc="Enable the recursive super pickaxe pickaxe mode", min=1, max=1)
    @CommandPermissions(value={"worldedit.superpickaxe.recursive"})
    public void recursive(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        double range = args.getDouble(0);
        if (range > (double)config.maxSuperPickaxeSize) {
            player.printError("Maximum range: " + config.maxSuperPickaxeSize);
            return;
        }
        session.setSuperPickaxe(new RecursivePickaxe(range));
        session.enableSuperPickAxe();
        player.print("Mode changed. Left click with a pickaxe. // to disable.");
    }
}

