/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.commands;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import wecui.vendor.com.sk89q.minecraft.util.commands.Command;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandContext;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandPermissions;
import wecui.vendor.com.sk89q.minecraft.util.commands.Console;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.WorldEdit;
import wecui.vendor.com.sk89q.worldedit.WorldEditException;
import wecui.vendor.com.sk89q.worldedit.commands.UtilityCommands;

public class WorldEditCommands {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private final WorldEdit we;

    public WorldEditCommands(WorldEdit we2) {
        this.we = we2;
    }

    @Command(aliases={"version", "ver"}, usage="", desc="Get WorldEdit version", min=0, max=0)
    @Console
    public void version(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.print("WorldEdit version " + WorldEdit.getVersion());
        player.print("http://www.sk89q.com/projects/worldedit/");
    }

    @Command(aliases={"reload"}, usage="", desc="Reload WorldEdit", min=0, max=0)
    @CommandPermissions(value={"worldedit.reload"})
    @Console
    public void reload(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        this.we.getServer().reload();
        player.print("Configuration reloaded!");
    }

    @Command(aliases={"cui"}, usage="", desc="Complete CUI handshake", min=0, max=0)
    public void cui(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setCUISupport(true);
        session.dispatchCUISetup(player);
    }

    @Command(aliases={"tz"}, usage="[timezone]", desc="Set your timezone", min=1, max=1)
    @Console
    public void tz(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        TimeZone tz2 = TimeZone.getTimeZone(args.getString(0));
        session.setTimezone(tz2);
        player.print("Timezone set for this session to: " + tz2.getDisplayName());
        player.print("The current time in that timezone is: " + dateFormat.format(Calendar.getInstance(tz2).getTime()));
    }

    @Command(aliases={"help"}, usage="[<command>]", desc="Displays help for the given command or lists all commands.", min=0, max=-1)
    @Console
    public void help(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        UtilityCommands.help(args, this.we, session, player, editSession);
    }
}

