/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.data;

import com.sk89q.jnbt.Tag;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import wecui.vendor.com.sk89q.jnbt.ByteArrayTag;
import wecui.vendor.com.sk89q.jnbt.ByteTag;
import wecui.vendor.com.sk89q.jnbt.CompoundTag;
import wecui.vendor.com.sk89q.jnbt.IntTag;
import wecui.vendor.com.sk89q.jnbt.ListTag;
import wecui.vendor.com.sk89q.jnbt.NBTUtils;
import wecui.vendor.com.sk89q.worldedit.BlockVector;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.ChestBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.DispenserBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.FurnaceBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.MobSpawnerBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.NoteBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.SignBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.TileEntityBlock;
import wecui.vendor.com.sk89q.worldedit.data.Chunk;
import wecui.vendor.com.sk89q.worldedit.data.DataException;
import wecui.vendor.com.sk89q.worldedit.data.InvalidFormatException;

public class AnvilChunk
implements Chunk {
    private CompoundTag rootTag;
    private byte[][] blocks;
    private byte[][] data;
    private int rootX;
    private int rootZ;
    private Map<com.sk89q.worldedit.BlockVector, Map<String, Tag>> tileEntities;
    private LocalWorld world;

    public AnvilChunk(LocalWorld world, CompoundTag tag) throws DataException {
        int i2;
        this.rootTag = tag;
        this.world = world;
        this.rootX = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "xPos", IntTag.class).getValue();
        this.rootZ = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "zPos", IntTag.class).getValue();
        this.blocks = new byte[16][4096];
        this.data = new byte[16][2048];
        Object sections = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "Sections", ListTag.class).getValue();
        Iterator i$ = sections.iterator();
        while (i$.hasNext()) {
            byte y2;
            CompoundTag compoundsection;
            wecui.vendor.com.sk89q.jnbt.Tag section = (wecui.vendor.com.sk89q.jnbt.Tag)i$.next();
            if (!(section instanceof CompoundTag) || !(compoundsection = (CompoundTag)section).getValue().containsKey("Y") || (y2 = NBTUtils.getChildTag((Map<String, Tag>)compoundsection.getValue(), "Y", ByteTag.class).getValue().byteValue()) < 0 || y2 >= 16) continue;
            this.blocks[y2] = NBTUtils.getChildTag((Map<String, Tag>)compoundsection.getValue(), "Blocks", ByteArrayTag.class).getValue();
            this.data[y2] = NBTUtils.getChildTag((Map<String, Tag>)compoundsection.getValue(), "Data", ByteArrayTag.class).getValue();
        }
        int sectionsize = 4096;
        for (i2 = 0; i2 < this.blocks.length; ++i2) {
            if (this.blocks[i2].length == sectionsize) continue;
            throw new InvalidFormatException("Chunk blocks byte array expected to be " + sectionsize + " bytes; found " + this.blocks[i2].length);
        }
        for (i2 = 0; i2 < this.data.length; ++i2) {
            if (this.data[i2].length == sectionsize / 2) continue;
            throw new InvalidFormatException("Chunk block data byte array expected to be " + sectionsize + " bytes; found " + this.data[i2].length);
        }
    }

    @Override
    public int getBlockID(Vector pos) throws DataException {
        int x2 = pos.getBlockX() - this.rootX * 16;
        int y2 = pos.getBlockY();
        int z2 = pos.getBlockZ() - this.rootZ * 16;
        int section = y2 >> 4;
        if (section < 0 || section >= this.blocks.length) {
            throw new DataException("Chunk does not contain position " + pos);
        }
        int yindex = y2 & 0xF;
        if (yindex < 0 || yindex >= 16) {
            throw new DataException("Chunk does not contain position " + pos);
        }
        int index = x2 + (z2 * 16 + yindex * 16 * 16);
        try {
            return this.blocks[section][index];
        }
        catch (IndexOutOfBoundsException e2) {
            throw new DataException("Chunk does not contain position " + pos);
        }
    }

    @Override
    public int getBlockData(Vector pos) throws DataException {
        int x2 = pos.getBlockX() - this.rootX * 16;
        int y2 = pos.getBlockY();
        int z2 = pos.getBlockZ() - this.rootZ * 16;
        int section = y2 >> 4;
        if (section < 0 || section >= this.blocks.length) {
            throw new DataException("Chunk does not contain position " + pos);
        }
        int yindex = y2 & 0xF;
        if (yindex < 0 || yindex >= 16) {
            throw new DataException("Chunk does not contain position " + pos);
        }
        int index = x2 + (z2 * 16 + yindex * 16 * 16);
        boolean shift = index % 2 == 0;
        index /= 2;
        try {
            if (!shift) {
                return (this.data[section][index] & 0xF0) >> 4;
            }
            return this.data[section][index] & 0xF;
        }
        catch (IndexOutOfBoundsException e2) {
            throw new DataException("Chunk does not contain position " + pos);
        }
    }

    private void populateTileEntities() throws DataException {
        Object tags = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "TileEntities", ListTag.class).getValue();
        this.tileEntities = new HashMap<com.sk89q.worldedit.BlockVector, Map<String, Tag>>();
        Iterator i$ = tags.iterator();
        while (i$.hasNext()) {
            wecui.vendor.com.sk89q.jnbt.Tag tag = (wecui.vendor.com.sk89q.jnbt.Tag)i$.next();
            if (!(tag instanceof CompoundTag)) {
                throw new InvalidFormatException("CompoundTag expected in TileEntities");
            }
            CompoundTag t2 = (CompoundTag)tag;
            int x2 = 0;
            int y2 = 0;
            int z2 = 0;
            HashMap values = new HashMap();
            for (Map.Entry entry : t2.getValue().entrySet()) {
                if (((String)entry.getKey()).equals("x")) {
                    if (entry.getValue() instanceof IntTag) {
                        x2 = ((IntTag)entry.getValue()).getValue();
                    }
                } else if (((String)entry.getKey()).equals("y")) {
                    if (entry.getValue() instanceof IntTag) {
                        y2 = ((IntTag)entry.getValue()).getValue();
                    }
                } else if (((String)entry.getKey()).equals("z") && entry.getValue() instanceof IntTag) {
                    z2 = ((IntTag)entry.getValue()).getValue();
                }
                values.put(entry.getKey(), entry.getValue());
            }
            BlockVector vec = new BlockVector(x2, y2, z2);
            this.tileEntities.put((com.sk89q.worldedit.BlockVector)vec, values);
        }
    }

    private Map<String, Tag> getBlockTileEntity(Vector pos) throws DataException {
        if (this.tileEntities == null) {
            this.populateTileEntities();
        }
        return this.tileEntities.get(new BlockVector(pos));
    }

    @Override
    public BaseBlock getBlock(Vector pos) throws DataException {
        int id2 = this.getBlockID(pos);
        int data = this.getBlockData(pos);
        BaseBlock block = id2 == 68 || id2 == 63 ? new SignBlock(id2, data) : (id2 == 54 ? new ChestBlock(data) : (id2 == 61 || id2 == 62 ? new FurnaceBlock(id2, data) : (id2 == 23 ? new DispenserBlock(data) : (id2 == 52 ? new MobSpawnerBlock(data) : (id2 == 25 ? new NoteBlock(data) : new BaseBlock(id2, data))))));
        if (block instanceof TileEntityBlock) {
            Map<String, Tag> tileEntity = this.getBlockTileEntity(pos);
            ((TileEntityBlock)((Object)block)).fromTileEntityNBT(tileEntity);
        }
        return block;
    }
}

