/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.data;

import java.io.IOException;
import java.io.InputStream;

public class ForwardSeekableInputStream
extends InputStream {
    protected InputStream parent;
    protected long position = 0L;

    public ForwardSeekableInputStream(InputStream parent) {
        this.parent = parent;
    }

    @Override
    public int read() throws IOException {
        int ret = this.parent.read();
        ++this.position;
        return ret;
    }

    @Override
    public int available() throws IOException {
        return this.parent.available();
    }

    @Override
    public void close() throws IOException {
        this.parent.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.parent.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.parent.markSupported();
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int read = super.read(b2, off, len);
        this.position += (long)read;
        return read;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        int read = this.parent.read(b2);
        this.position += (long)read;
        return read;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.parent.reset();
    }

    @Override
    public long skip(long n2) throws IOException {
        long skipped = this.parent.skip(n2);
        this.position += skipped;
        return skipped;
    }

    public void seek(long n2) throws IOException {
        long diff = n2 - this.position;
        if (diff < 0L) {
            throw new IOException("Can't seek backwards");
        }
        if (diff == 0L) {
            return;
        }
        if (this.skip(diff) < diff) {
            throw new IOException("Failed to seek " + diff + " bytes");
        }
    }
}

