/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import wecui.vendor.com.sk89q.jnbt.CompoundTag;
import wecui.vendor.com.sk89q.jnbt.NBTInputStream;
import wecui.vendor.com.sk89q.jnbt.Tag;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Vector2D;
import wecui.vendor.com.sk89q.worldedit.data.ChunkStore;
import wecui.vendor.com.sk89q.worldedit.data.ChunkStoreException;
import wecui.vendor.com.sk89q.worldedit.data.DataException;
import wecui.vendor.com.sk89q.worldedit.data.McRegionReader;

public abstract class McRegionChunkStore
extends ChunkStore {
    protected String curFilename = null;
    protected McRegionReader cachedReader = null;

    public static String getFilename(Vector2D pos) {
        int x2 = pos.getBlockX();
        int z2 = pos.getBlockZ();
        String filename = "r." + (x2 >> 5) + "." + (z2 >> 5) + ".mcr";
        return filename;
    }

    protected McRegionReader getReader(Vector2D pos, String worldname) throws DataException, IOException {
        String filename = McRegionChunkStore.getFilename(pos);
        if (this.curFilename != null) {
            if (this.curFilename.equals(filename)) {
                return this.cachedReader;
            }
            try {
                this.cachedReader.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        InputStream stream = this.getInputStream(filename, worldname);
        this.cachedReader = new McRegionReader(stream);
        return this.cachedReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompoundTag getChunkTag(Vector2D pos, LocalWorld world) throws DataException, IOException {
        McRegionReader reader = this.getReader(pos, world.getName());
        InputStream stream = reader.getChunkInputStream(pos);
        NBTInputStream nbt = new NBTInputStream(stream);
        try {
            Tag tag = nbt.readTag();
            if (!(tag instanceof CompoundTag)) {
                throw new ChunkStoreException("CompoundTag expected for chunk; got " + tag.getClass().getName());
            }
            Object children = ((CompoundTag)tag).getValue();
            CompoundTag rootTag = null;
            for (Map.Entry entry : children.entrySet()) {
                if (!((String)entry.getKey()).equals("Level")) continue;
                if (entry.getValue() instanceof CompoundTag) {
                    rootTag = (CompoundTag)entry.getValue();
                    break;
                }
                throw new ChunkStoreException("CompoundTag expected for 'Level'; got " + ((Tag)entry.getValue()).getClass().getName());
            }
            if (rootTag == null) {
                throw new ChunkStoreException("Missing root 'Level' tag");
            }
            CompoundTag compoundTag = rootTag;
            return compoundTag;
        }
        finally {
            stream.close();
        }
    }

    protected abstract InputStream getInputStream(String var1, String var2) throws IOException, DataException;

    @Override
    public void close() throws IOException {
        if (this.cachedReader != null) {
            this.cachedReader.close();
        }
    }
}

