/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.data;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import wecui.vendor.com.sk89q.worldedit.Vector2D;
import wecui.vendor.com.sk89q.worldedit.data.DataException;
import wecui.vendor.com.sk89q.worldedit.data.ForwardSeekableInputStream;

public class McRegionReader {
    protected static final int VERSION_GZIP = 1;
    protected static final int VERSION_DEFLATE = 2;
    protected static final int SECTOR_BYTES = 4096;
    protected static final int SECTOR_INTS = 1024;
    public static final int CHUNK_HEADER_SIZE = 5;
    protected ForwardSeekableInputStream stream;
    protected DataInputStream dataStream;
    protected int[] offsets;

    public McRegionReader(InputStream stream) throws DataException, IOException {
        this.stream = new ForwardSeekableInputStream(stream);
        this.dataStream = new DataInputStream(this.stream);
        this.readHeader();
    }

    private void readHeader() throws DataException, IOException {
        this.offsets = new int[1024];
        for (int i2 = 0; i2 < 1024; ++i2) {
            int offset;
            this.offsets[i2] = offset = this.dataStream.readInt();
        }
    }

    public synchronized InputStream getChunkInputStream(Vector2D pos) throws IOException, DataException {
        int x2 = pos.getBlockX() & 0x1F;
        int z2 = pos.getBlockZ() & 0x1F;
        if (x2 < 0 || x2 >= 32 || z2 < 0 || z2 >= 32) {
            throw new DataException("MCRegion file does not contain " + x2 + "," + z2);
        }
        int offset = this.getOffset(x2, z2);
        if (offset == 0) {
            return null;
        }
        int sectorNumber = offset >> 8;
        int numSectors = offset & 0xFF;
        this.stream.seek(sectorNumber * 4096);
        int length = this.dataStream.readInt();
        if (length > 4096 * numSectors) {
            throw new DataException("MCRegion chunk at " + x2 + "," + z2 + " has an invalid length of " + length);
        }
        byte version = this.dataStream.readByte();
        if (version == 1) {
            byte[] data = new byte[length - 1];
            if (this.dataStream.read(data) < length - 1) {
                throw new DataException("MCRegion file does not contain " + x2 + "," + z2 + " in full");
            }
            return new GZIPInputStream(new ByteArrayInputStream(data));
        }
        if (version == 2) {
            byte[] data = new byte[length - 1];
            if (this.dataStream.read(data) < length - 1) {
                throw new DataException("MCRegion file does not contain " + x2 + "," + z2 + " in full");
            }
            return new InflaterInputStream(new ByteArrayInputStream(data));
        }
        throw new DataException("MCRegion chunk at " + x2 + "," + z2 + " has an unsupported version of " + version);
    }

    private int getOffset(int x2, int z2) {
        return this.offsets[x2 + z2 * 32];
    }

    public boolean hasChunk(int x2, int z2) {
        return this.getOffset(x2, z2) != 0;
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

