/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.data;

import com.sk89q.jnbt.Tag;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import wecui.vendor.com.sk89q.jnbt.ByteArrayTag;
import wecui.vendor.com.sk89q.jnbt.CompoundTag;
import wecui.vendor.com.sk89q.jnbt.IntTag;
import wecui.vendor.com.sk89q.jnbt.ListTag;
import wecui.vendor.com.sk89q.jnbt.NBTUtils;
import wecui.vendor.com.sk89q.worldedit.BlockVector;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.ChestBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.DispenserBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.FurnaceBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.MobSpawnerBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.NoteBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.SignBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.TileEntityBlock;
import wecui.vendor.com.sk89q.worldedit.data.Chunk;
import wecui.vendor.com.sk89q.worldedit.data.DataException;
import wecui.vendor.com.sk89q.worldedit.data.InvalidFormatException;

public class OldChunk
implements Chunk {
    private CompoundTag rootTag;
    private byte[] blocks;
    private byte[] data;
    private int rootX;
    private int rootZ;
    private Map<com.sk89q.worldedit.BlockVector, Map<String, Tag>> tileEntities;
    private LocalWorld world;

    public OldChunk(LocalWorld world, CompoundTag tag) throws DataException {
        this.rootTag = tag;
        this.world = world;
        this.blocks = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "Blocks", ByteArrayTag.class).getValue();
        this.data = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "Data", ByteArrayTag.class).getValue();
        this.rootX = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "xPos", IntTag.class).getValue();
        this.rootZ = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "zPos", IntTag.class).getValue();
        int size = 32768;
        if (this.blocks.length != size) {
            throw new InvalidFormatException("Chunk blocks byte array expected to be " + size + " bytes; found " + this.blocks.length);
        }
        if (this.data.length != size / 2) {
            throw new InvalidFormatException("Chunk block data byte array expected to be " + size + " bytes; found " + this.data.length);
        }
    }

    @Override
    public int getBlockID(Vector pos) throws DataException {
        if (pos.getBlockY() >= 128) {
            return 0;
        }
        int x2 = pos.getBlockX() - this.rootX * 16;
        int y2 = pos.getBlockY();
        int z2 = pos.getBlockZ() - this.rootZ * 16;
        int index = y2 + (z2 * 128 + x2 * 128 * 16);
        try {
            return this.blocks[index];
        }
        catch (IndexOutOfBoundsException e2) {
            throw new DataException("Chunk does not contain position " + pos);
        }
    }

    @Override
    public int getBlockData(Vector pos) throws DataException {
        int z2;
        if (pos.getBlockY() >= 128) {
            return 0;
        }
        int x2 = pos.getBlockX() - this.rootX * 16;
        int y2 = pos.getBlockY();
        int index = y2 + ((z2 = pos.getBlockZ() - this.rootZ * 16) * 128 + x2 * 128 * 16);
        boolean shift = index % 2 == 0;
        index /= 2;
        try {
            if (!shift) {
                return (this.data[index] & 0xF0) >> 4;
            }
            return this.data[index] & 0xF;
        }
        catch (IndexOutOfBoundsException e2) {
            throw new DataException("Chunk does not contain position " + pos);
        }
    }

    private void populateTileEntities() throws DataException {
        Object tags = NBTUtils.getChildTag((Map<String, Tag>)this.rootTag.getValue(), "TileEntities", ListTag.class).getValue();
        this.tileEntities = new HashMap<com.sk89q.worldedit.BlockVector, Map<String, Tag>>();
        Iterator i$ = tags.iterator();
        while (i$.hasNext()) {
            wecui.vendor.com.sk89q.jnbt.Tag tag = (wecui.vendor.com.sk89q.jnbt.Tag)i$.next();
            if (!(tag instanceof CompoundTag)) {
                throw new InvalidFormatException("CompoundTag expected in TileEntities");
            }
            CompoundTag t2 = (CompoundTag)tag;
            int x2 = 0;
            int y2 = 0;
            int z2 = 0;
            HashMap values = new HashMap();
            for (Map.Entry entry : t2.getValue().entrySet()) {
                if (((String)entry.getKey()).equals("x")) {
                    if (entry.getValue() instanceof IntTag) {
                        x2 = ((IntTag)entry.getValue()).getValue();
                    }
                } else if (((String)entry.getKey()).equals("y")) {
                    if (entry.getValue() instanceof IntTag) {
                        y2 = ((IntTag)entry.getValue()).getValue();
                    }
                } else if (((String)entry.getKey()).equals("z") && entry.getValue() instanceof IntTag) {
                    z2 = ((IntTag)entry.getValue()).getValue();
                }
                values.put(entry.getKey(), entry.getValue());
            }
            BlockVector vec = new BlockVector(x2, y2, z2);
            this.tileEntities.put((com.sk89q.worldedit.BlockVector)vec, values);
        }
    }

    private Map<String, Tag> getBlockTileEntity(Vector pos) throws DataException {
        if (this.tileEntities == null) {
            this.populateTileEntities();
        }
        return this.tileEntities.get(new BlockVector(pos));
    }

    @Override
    public BaseBlock getBlock(Vector pos) throws DataException {
        int id2 = this.getBlockID(pos);
        int data = this.getBlockData(pos);
        BaseBlock block = id2 == 68 || id2 == 63 ? new SignBlock(id2, data) : (id2 == 54 ? new ChestBlock(data) : (id2 == 61 || id2 == 62 ? new FurnaceBlock(id2, data) : (id2 == 23 ? new DispenserBlock(data) : (id2 == 52 ? new MobSpawnerBlock(data) : (id2 == 25 ? new NoteBlock(data) : new BaseBlock(id2, data))))));
        if (block instanceof TileEntityBlock) {
            Map<String, Tag> tileEntity = this.getBlockTileEntity(pos);
            ((TileEntityBlock)((Object)block)).fromTileEntityNBT(tileEntity);
        }
        return block;
    }
}

