/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.dev;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import wecui.vendor.com.sk89q.minecraft.util.commands.Command;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandPermissions;
import wecui.vendor.com.sk89q.minecraft.util.commands.NestedCommand;
import wecui.vendor.com.sk89q.worldedit.commands.ChunkCommands;
import wecui.vendor.com.sk89q.worldedit.commands.ClipboardCommands;
import wecui.vendor.com.sk89q.worldedit.commands.GeneralCommands;
import wecui.vendor.com.sk89q.worldedit.commands.GenerationCommands;
import wecui.vendor.com.sk89q.worldedit.commands.HistoryCommands;
import wecui.vendor.com.sk89q.worldedit.commands.NavigationCommands;
import wecui.vendor.com.sk89q.worldedit.commands.RegionCommands;
import wecui.vendor.com.sk89q.worldedit.commands.ScriptingCommands;
import wecui.vendor.com.sk89q.worldedit.commands.SelectionCommands;
import wecui.vendor.com.sk89q.worldedit.commands.SnapshotUtilCommands;
import wecui.vendor.com.sk89q.worldedit.commands.ToolCommands;
import wecui.vendor.com.sk89q.worldedit.commands.ToolUtilCommands;
import wecui.vendor.com.sk89q.worldedit.commands.UtilityCommands;

public class DocumentationPrinter {
    public static void main(String[] args) throws IOException {
        File commandsDir = new File(args[0]);
        List<Class<?>> commandClasses = DocumentationPrinter.getCommandClasses(commandsDir);
        System.out.println("Writing permissions wiki table...");
        DocumentationPrinter.writePermissionsWikiTable(commandClasses);
        System.out.println("Writing Bukkit plugin.yml...");
        DocumentationPrinter.writeBukkitYAML();
        System.out.println("Done!");
    }

    private static List<Class<?>> getCommandClasses(File dir) {
        ArrayList classes = new ArrayList();
        classes.add(ChunkCommands.class);
        classes.add(ClipboardCommands.class);
        classes.add(GeneralCommands.class);
        classes.add(GenerationCommands.class);
        classes.add(HistoryCommands.class);
        classes.add(NavigationCommands.class);
        classes.add(RegionCommands.class);
        classes.add(ScriptingCommands.class);
        classes.add(SelectionCommands.class);
        classes.add(SnapshotUtilCommands.class);
        classes.add(ToolUtilCommands.class);
        classes.add(ToolCommands.class);
        classes.add(UtilityCommands.class);
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePermissionsWikiTable(List<Class<?>> commandClasses) throws IOException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream("wiki_permissions.txt");
            PrintStream print = new PrintStream(stream);
            DocumentationPrinter._writePermissionsWikiTable(print, commandClasses, "/");
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static void _writePermissionsWikiTable(PrintStream stream, List<Class<?>> commandClasses, String prefix) {
        for (Class<?> cls : commandClasses) {
            for (Method method : cls.getMethods()) {
                if (!method.isAnnotationPresent(Command.class)) continue;
                Command cmd = method.getAnnotation(Command.class);
                stream.println("|-");
                stream.print("| " + prefix + cmd.aliases()[0]);
                stream.print(" || ");
                if (method.isAnnotationPresent(CommandPermissions.class)) {
                    CommandPermissions perms = method.getAnnotation(CommandPermissions.class);
                    String[] permKeys = perms.value();
                    for (int i2 = 0; i2 < permKeys.length; ++i2) {
                        if (i2 > 0) {
                            stream.print(", ");
                        }
                        stream.print(permKeys[i2]);
                    }
                }
                stream.print(" || ");
                boolean firstAlias = true;
                if (cmd.aliases().length != 0) {
                    for (String alias : cmd.aliases()) {
                        if (!firstAlias) {
                            stream.print("<br />");
                        }
                        stream.print(prefix + alias);
                        firstAlias = false;
                    }
                }
                stream.print(" || ");
                if (cmd.flags() != null && !cmd.flags().equals("")) {
                    stream.print(cmd.flags());
                }
                stream.print(" || ");
                if (cmd.desc() != null && !cmd.desc().equals("")) {
                    stream.print(cmd.desc());
                }
                stream.println();
                if (!method.isAnnotationPresent(NestedCommand.class)) continue;
                NestedCommand nested = method.getAnnotation(NestedCommand.class);
                Class<?>[] nestedClasses = nested.value();
                DocumentationPrinter._writePermissionsWikiTable(stream, Arrays.asList(nestedClasses), prefix + cmd.aliases()[0] + " ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBukkitYAML() throws IOException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream("plugin.yml");
            PrintStream print = new PrintStream(stream);
            DocumentationPrinter._writeBukkitYAML(print);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static void _writeBukkitYAML(PrintStream stream) {
        stream.println("name: WorldEdit");
        stream.println("main: com.sk89q.worldedit.bukkit.WorldEditPlugin");
        stream.println("version: ${project.version}");
        stream.println("softdepend: [Spout] #hack to fix trove errors");
        stream.println();
        stream.println();
        stream.println("# Permissions aren't here. Read http://wiki.sk89q.com/wiki/WEPIF/DinnerPerms");
        stream.println("# for how WorldEdit permissions actually work.");
    }
}

