/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.expression.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import wecui.vendor.com.sk89q.worldedit.expression.Identifiable;
import wecui.vendor.com.sk89q.worldedit.expression.lexer.tokens.OperatorToken;
import wecui.vendor.com.sk89q.worldedit.expression.lexer.tokens.Token;
import wecui.vendor.com.sk89q.worldedit.expression.parser.ParserException;
import wecui.vendor.com.sk89q.worldedit.expression.parser.UnaryOperator;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.Conditional;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.Operators;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.RValue;

public final class ParserProcessors {
    private static final Map<String, String> unaryOpMap = new HashMap<String, String>();
    private static final Map<String, String>[] binaryOpMapsLA;
    private static final Map<String, String>[] binaryOpMapsRA;

    static RValue processExpression(LinkedList<com.sk89q.worldedit.expression.Identifiable> input) throws ParserException {
        return ParserProcessors.processBinaryOpsRA(input, binaryOpMapsRA.length - 1);
    }

    private static RValue processBinaryOpsLA(LinkedList<com.sk89q.worldedit.expression.Identifiable> input, int level) throws ParserException {
        if (level < 0) {
            return ParserProcessors.processUnaryOps(input);
        }
        LinkedList<com.sk89q.worldedit.expression.Identifiable> lhs = new LinkedList<com.sk89q.worldedit.expression.Identifiable>();
        LinkedList<com.sk89q.worldedit.expression.Identifiable> rhs = new LinkedList<com.sk89q.worldedit.expression.Identifiable>();
        String operator = null;
        Iterator<com.sk89q.worldedit.expression.Identifiable> it2 = input.descendingIterator();
        while (it2.hasNext()) {
            Identifiable identifiable = (Identifiable)it2.next();
            if (operator == null) {
                rhs.addFirst((com.sk89q.worldedit.expression.Identifiable)identifiable);
                if (!(identifiable instanceof OperatorToken) || (operator = binaryOpMapsLA[level].get(((OperatorToken)identifiable).operator)) == null) continue;
                rhs.removeFirst();
                continue;
            }
            lhs.addFirst((com.sk89q.worldedit.expression.Identifiable)identifiable);
        }
        RValue rhsInvokable = ParserProcessors.processBinaryOpsLA(rhs, level - 1);
        if (operator == null) {
            return rhsInvokable;
        }
        RValue lhsInvokable = ParserProcessors.processBinaryOpsLA(lhs, level);
        try {
            return Operators.getOperator(((Identifiable)input.get(0)).getPosition(), operator, lhsInvokable, rhsInvokable);
        }
        catch (NoSuchMethodException e2) {
            Token operatorToken = (Token)input.get(lhs.size());
            throw new ParserException(operatorToken.getPosition(), "Couldn't find operator '" + operator + "'");
        }
    }

    private static RValue processBinaryOpsRA(LinkedList<com.sk89q.worldedit.expression.Identifiable> input, int level) throws ParserException {
        if (level < 0) {
            return ParserProcessors.processTernaryOps(input);
        }
        LinkedList<com.sk89q.worldedit.expression.Identifiable> lhs = new LinkedList<com.sk89q.worldedit.expression.Identifiable>();
        LinkedList<com.sk89q.worldedit.expression.Identifiable> rhs = new LinkedList<com.sk89q.worldedit.expression.Identifiable>();
        String operator = null;
        for (Identifiable identifiable : input) {
            if (operator == null) {
                lhs.addLast((com.sk89q.worldedit.expression.Identifiable)identifiable);
                if (!(identifiable instanceof OperatorToken) || (operator = binaryOpMapsRA[level].get(((OperatorToken)identifiable).operator)) == null) continue;
                lhs.removeLast();
                continue;
            }
            rhs.addLast((com.sk89q.worldedit.expression.Identifiable)identifiable);
        }
        RValue lhsInvokable = ParserProcessors.processBinaryOpsRA(lhs, level - 1);
        if (operator == null) {
            return lhsInvokable;
        }
        RValue rValue = ParserProcessors.processBinaryOpsRA(rhs, level);
        try {
            return Operators.getOperator(((Identifiable)input.get(0)).getPosition(), operator, lhsInvokable, rValue);
        }
        catch (NoSuchMethodException e2) {
            Token operatorToken = (Token)input.get(lhs.size());
            throw new ParserException(operatorToken.getPosition(), "Couldn't find operator '" + operator + "'");
        }
    }

    private static RValue processTernaryOps(LinkedList<com.sk89q.worldedit.expression.Identifiable> input) throws ParserException {
        LinkedList<com.sk89q.worldedit.expression.Identifiable> lhs = new LinkedList<com.sk89q.worldedit.expression.Identifiable>();
        LinkedList<com.sk89q.worldedit.expression.Identifiable> mhs = new LinkedList<com.sk89q.worldedit.expression.Identifiable>();
        LinkedList<com.sk89q.worldedit.expression.Identifiable> rhs = new LinkedList<com.sk89q.worldedit.expression.Identifiable>();
        int partsFound = 0;
        int conditionalsFound = 0;
        for (Identifiable identifiable : input) {
            char character = identifiable.id();
            switch (character) {
                case '?': {
                    ++conditionalsFound;
                    break;
                }
                case ':': {
                    --conditionalsFound;
                }
            }
            if (conditionalsFound < 0) {
                throw new ParserException(identifiable.getPosition(), "Unexpected ':'");
            }
            switch (partsFound) {
                case 0: {
                    if (character == '?') {
                        System.out.println("question mark found");
                        partsFound = 1;
                        break;
                    }
                    lhs.addLast((com.sk89q.worldedit.expression.Identifiable)identifiable);
                    break;
                }
                case 1: {
                    if (conditionalsFound == 0 && character == ':') {
                        System.out.println("matching colon found");
                        partsFound = 2;
                        break;
                    }
                    mhs.addLast((com.sk89q.worldedit.expression.Identifiable)identifiable);
                    break;
                }
                case 2: {
                    rhs.addLast((com.sk89q.worldedit.expression.Identifiable)identifiable);
                }
            }
        }
        if (partsFound < 2) {
            return ParserProcessors.processBinaryOpsLA(input, binaryOpMapsLA.length - 1);
        }
        RValue lhsInvokable = ParserProcessors.processBinaryOpsLA(lhs, binaryOpMapsLA.length - 1);
        RValue rValue = ParserProcessors.processTernaryOps(mhs);
        RValue rhsInvokable = ParserProcessors.processTernaryOps(rhs);
        return new Conditional(((Identifiable)input.get(lhs.size())).getPosition(), lhsInvokable, rValue, rhsInvokable);
    }

    private static RValue processUnaryOps(LinkedList<com.sk89q.worldedit.expression.Identifiable> input) throws ParserException {
        Identifiable last;
        LinkedList<UnaryOperator> postfixes = new LinkedList<UnaryOperator>();
        while (true) {
            if (input.isEmpty()) {
                throw new ParserException(-1, "Expression missing.");
            }
            last = (Identifiable)input.removeLast();
            if (last instanceof OperatorToken) {
                postfixes.addLast(new UnaryOperator(last.getPosition(), "x" + ((OperatorToken)last).operator));
                continue;
            }
            if (!(last instanceof UnaryOperator)) break;
            postfixes.addLast(new UnaryOperator(last.getPosition(), "x" + ((UnaryOperator)last).operator));
        }
        Identifiable center = last;
        if (!(center instanceof RValue)) {
            throw new ParserException(center.getPosition(), "Expected expression, found " + center);
        }
        input.addAll(postfixes);
        RValue ret = (RValue)center;
        while (!input.isEmpty()) {
            Identifiable last2 = (Identifiable)input.removeLast();
            int lastPosition = last2.getPosition();
            if (last2 instanceof UnaryOperator) {
                String operator = ((UnaryOperator)last2).operator;
                if (operator.equals("+")) continue;
                String opName = unaryOpMap.get(operator);
                if (opName != null) {
                    try {
                        ret = Operators.getOperator(lastPosition, opName, ret);
                        continue;
                    }
                    catch (NoSuchMethodException e2) {
                        throw new ParserException(lastPosition, "No such prefix operator: " + operator);
                    }
                }
            }
            if (last2 instanceof Token) {
                throw new ParserException(lastPosition, "Extra token found in expression: " + last2);
            }
            if (last2 instanceof RValue) {
                throw new ParserException(lastPosition, "Extra expression found: " + last2);
            }
            throw new ParserException(lastPosition, "Extra element found: " + last2);
        }
        return ret;
    }

    static {
        unaryOpMap.put("-", "neg");
        unaryOpMap.put("!", "not");
        unaryOpMap.put("~", "inv");
        unaryOpMap.put("++", "inc");
        unaryOpMap.put("--", "dec");
        unaryOpMap.put("x++", "postinc");
        unaryOpMap.put("x--", "postdec");
        unaryOpMap.put("x!", "fac");
        Object[][][] binaryOpsLA = new Object[][][]{{{"^", "pow"}, {"**", "pow"}}, {{"*", "mul"}, {"/", "div"}, {"%", "mod"}}, {{"+", "add"}, {"-", "sub"}}, {{"<<", "shl"}, {">>", "shr"}}, {{"<", "lth"}, {">", "gth"}, {"<=", "leq"}, {">=", "geq"}}, {{"==", "equ"}, {"!=", "neq"}, {"~=", "near"}}, {{"&&", "and"}}, {{"||", "or"}}};
        Object[][][] binaryOpsRA = new Object[][][]{{{"=", "ass"}, {"+=", "aadd"}, {"-=", "asub"}, {"*=", "amul"}, {"/=", "adiv"}, {"%=", "amod"}, {"^=", "aexp"}}};
        binaryOpMapsLA = new Map[binaryOpsLA.length];
        Map[] lBinaryOpMapsLA = binaryOpMapsLA;
        block8: for (int i2 = 0; i2 < binaryOpsLA.length; ++i2) {
            Object[][] a2 = binaryOpsLA[i2];
            switch (a2.length) {
                case 0: {
                    lBinaryOpMapsLA[i2] = Collections.emptyMap();
                    continue block8;
                }
                case 1: {
                    Object[] first = a2[0];
                    lBinaryOpMapsLA[i2] = Collections.singletonMap((String)first[0], (String)first[1]);
                    continue block8;
                }
                default: {
                    HashMap<String, String> m2 = lBinaryOpMapsLA[i2] = new HashMap<String, String>();
                    for (int j2 = 0; j2 < a2.length; ++j2) {
                        Object[] element = a2[j2];
                        m2.put((String)element[0], (String)element[1]);
                    }
                }
            }
        }
        binaryOpMapsRA = new Map[binaryOpsRA.length];
        Map[] lBinaryOpMapsRA = binaryOpMapsRA;
        block10: for (int i3 = 0; i3 < binaryOpsRA.length; ++i3) {
            Object[][] a3 = binaryOpsRA[i3];
            switch (a3.length) {
                case 0: {
                    lBinaryOpMapsRA[i3] = Collections.emptyMap();
                    continue block10;
                }
                case 1: {
                    Object[] first = a3[0];
                    lBinaryOpMapsRA[i3] = Collections.singletonMap((String)first[0], (String)first[1]);
                    continue block10;
                }
                default: {
                    HashMap<String, String> m3 = lBinaryOpMapsRA[i3] = new HashMap<String, String>();
                    for (int j3 = 0; j3 < a3.length; ++j3) {
                        Object[] element = a3[j3];
                        m3.put((String)element[0], (String)element[1]);
                    }
                }
            }
        }
    }
}

