/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.expression.runtime;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.Constant;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.EvaluationException;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.LValueFunction;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.Node;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.RValue;

public class Function
extends Node {
    final Method method;
    final RValue[] args;

    Function(int position, Method method, RValue ... args) {
        super(position);
        this.method = method;
        this.args = args;
    }

    @Override
    public final double getValue() throws EvaluationException {
        return Function.invokeMethod(this.method, this.args);
    }

    protected static final double invokeMethod(Method method, Object[] args) throws EvaluationException {
        try {
            return (Double)method.invoke(null, args);
        }
        catch (InvocationTargetException e2) {
            if (e2.getTargetException() instanceof EvaluationException) {
                throw (EvaluationException)e2.getTargetException();
            }
            throw new EvaluationException(-1, "Exception caught while evaluating expression", e2.getTargetException());
        }
        catch (IllegalAccessException e3) {
            throw new EvaluationException(-1, "Internal error while evaluating expression", e3);
        }
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder(this.method.getName()).append('(');
        boolean first = true;
        for (RValue obj : this.args) {
            if (!first) {
                ret.append(", ");
            }
            first = false;
            ret.append(obj);
        }
        return ret.append(')').toString();
    }

    @Override
    public char id() {
        return 'f';
    }

    @Override
    public RValue optimize() throws EvaluationException {
        Object[] optimizedArgs = new RValue[this.args.length];
        boolean optimizable = !this.method.isAnnotationPresent(Dynamic.class);
        int position = this.getPosition();
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            optimizedArgs[i2] = this.args[i2].optimize();
            RValue optimized = optimizedArgs[i2];
            if (!(optimized instanceof Constant)) {
                optimizable = false;
            }
            if (optimized.getPosition() >= position) continue;
            position = optimized.getPosition();
        }
        if (optimizable) {
            return new Constant(position, Function.invokeMethod(this.method, optimizedArgs));
        }
        if (this instanceof LValueFunction) {
            return new LValueFunction(position, this.method, ((LValueFunction)this).setter, (RValue[])optimizedArgs);
        }
        return new Function(position, this.method, (RValue[])optimizedArgs);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Dynamic {
    }
}

