/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.expression.runtime;

import wecui.vendor.com.sk89q.worldedit.expression.runtime.BreakException;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.EvaluationException;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.LValue;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.Node;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.RValue;

public class SimpleFor
extends Node {
    LValue counter;
    RValue first;
    RValue last;
    RValue body;

    public SimpleFor(int position, LValue counter, RValue first, RValue last, RValue body) {
        super(position);
        this.counter = counter;
        this.first = first;
        this.last = last;
        this.body = body;
    }

    @Override
    public double getValue() throws EvaluationException {
        int iterations = 0;
        double ret = 0.0;
        double firstValue = this.first.getValue();
        double lastValue = this.last.getValue();
        for (double i2 = firstValue; i2 <= lastValue; i2 += 1.0) {
            if (iterations > 256) {
                throw new EvaluationException(this.getPosition(), "Loop exceeded 256 iterations.");
            }
            ++iterations;
            try {
                this.counter.assign(i2);
                ret = this.body.getValue();
            }
            catch (BreakException e2) {
                if (!e2.doContinue) break;
            }
        }
        return ret;
    }

    @Override
    public char id() {
        return 'S';
    }

    @Override
    public String toString() {
        return "for (" + this.counter + " = " + this.first + ", " + this.last + ") { " + this.body + " }";
    }

    @Override
    public RValue optimize() throws EvaluationException {
        return new SimpleFor(this.getPosition(), (LValue)this.counter.optimize(), this.first.optimize(), this.last.optimize(), this.body.optimize());
    }
}

