/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.expression.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.Break;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.BreakException;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.Constant;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.EvaluationException;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.Node;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.RValue;
import wecui.vendor.com.sk89q.worldedit.expression.runtime.Sequence;

public class Switch
extends Node
implements RValue {
    private final RValue parameter;
    private final Map<Double, Integer> valueMap;
    private final RValue[] caseStatements;
    private final RValue defaultCase;

    public Switch(int position, RValue parameter, List<Double> values, List<com.sk89q.worldedit.expression.runtime.RValue> caseStatements, RValue defaultCase) {
        this(position, parameter, Switch.invertList(values), caseStatements, defaultCase);
    }

    private static Map<Double, Integer> invertList(List<Double> values) {
        HashMap<Double, Integer> valueMap = new HashMap<Double, Integer>();
        for (int i2 = 0; i2 < values.size(); ++i2) {
            valueMap.put(values.get(i2), i2);
        }
        return valueMap;
    }

    private Switch(int position, RValue parameter, Map<Double, Integer> valueMap, List<com.sk89q.worldedit.expression.runtime.RValue> caseStatements, RValue defaultCase) {
        super(position);
        this.parameter = parameter;
        this.valueMap = valueMap;
        this.caseStatements = caseStatements.toArray(new RValue[caseStatements.size()]);
        this.defaultCase = defaultCase;
    }

    @Override
    public char id() {
        return 'W';
    }

    @Override
    public double getValue() throws EvaluationException {
        double parameter = this.parameter.getValue();
        try {
            double ret = 0.0;
            Integer index = this.valueMap.get(parameter);
            if (index != null) {
                for (int i2 = index.intValue(); i2 < this.caseStatements.length; ++i2) {
                    ret = this.caseStatements[i2].getValue();
                }
            }
            return this.defaultCase == null ? ret : this.defaultCase.getValue();
        }
        catch (BreakException e2) {
            if (e2.doContinue) {
                throw e2;
            }
            return 0.0;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append("switch (");
        sb2.append(this.parameter);
        sb2.append(") { ");
        for (int i2 = 0; i2 < this.caseStatements.length; ++i2) {
            RValue caseStatement = this.caseStatements[i2];
            sb2.append("case ");
            for (Map.Entry<Double, Integer> entry : this.valueMap.entrySet()) {
                if (entry.getValue() != i2) continue;
                sb2.append(entry.getKey());
                break;
            }
            sb2.append(": ");
            sb2.append(caseStatement);
            sb2.append(' ');
        }
        if (this.defaultCase != null) {
            sb2.append("default: ");
            sb2.append(this.defaultCase);
            sb2.append(' ');
        }
        sb2.append("}");
        return sb2.toString();
    }

    @Override
    public RValue optimize() throws EvaluationException {
        RValue optimizedParameter = this.parameter.optimize();
        ArrayList<com.sk89q.worldedit.expression.runtime.RValue> newSequence = new ArrayList<com.sk89q.worldedit.expression.runtime.RValue>();
        if (optimizedParameter instanceof Constant) {
            double parameter = optimizedParameter.getValue();
            Integer index = this.valueMap.get(parameter);
            if (index == null) {
                return this.defaultCase == null ? new Constant(this.getPosition(), 0.0) : this.defaultCase.optimize();
            }
            boolean breakDetected = false;
            block0: for (int i2 = index.intValue(); i2 < this.caseStatements.length && !breakDetected; ++i2) {
                RValue invokable = this.caseStatements[i2].optimize();
                if (invokable instanceof Sequence) {
                    for (RValue subInvokable : ((Sequence)invokable).sequence) {
                        if (subInvokable instanceof Break) {
                            breakDetected = true;
                            continue block0;
                        }
                        newSequence.add((com.sk89q.worldedit.expression.runtime.RValue)subInvokable);
                    }
                    continue;
                }
                newSequence.add((com.sk89q.worldedit.expression.runtime.RValue)invokable);
            }
            if (this.defaultCase != null && !breakDetected) {
                RValue invokable = this.defaultCase.optimize();
                if (invokable instanceof Sequence) {
                    for (RValue subInvokable : ((Sequence)invokable).sequence) {
                        newSequence.add((com.sk89q.worldedit.expression.runtime.RValue)subInvokable);
                    }
                } else {
                    newSequence.add((com.sk89q.worldedit.expression.runtime.RValue)invokable);
                }
            }
            return new Switch(this.getPosition(), optimizedParameter, Collections.singletonMap(parameter, 0), newSequence, null);
        }
        HashMap<Double, Integer> newValueMap = new HashMap<Double, Integer>();
        HashMap<Integer, Double> backMap = new HashMap<Integer, Double>();
        for (Map.Entry<Double, Integer> entry : this.valueMap.entrySet()) {
            backMap.put(entry.getValue(), entry.getKey());
        }
        for (int i3 = 0; i3 < this.caseStatements.length; ++i3) {
            RValue invokable = this.caseStatements[i3].optimize();
            Double caseValue = (Double)backMap.get(i3);
            if (caseValue != null) {
                newValueMap.put(caseValue, newSequence.size());
            }
            if (invokable instanceof Sequence) {
                for (RValue subInvokable : ((Sequence)invokable).sequence) {
                    newSequence.add((com.sk89q.worldedit.expression.runtime.RValue)subInvokable);
                }
                continue;
            }
            newSequence.add((com.sk89q.worldedit.expression.runtime.RValue)invokable);
        }
        return new Switch(this.getPosition(), optimizedParameter, newValueMap, newSequence, this.defaultCase.optimize());
    }
}

