/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.filtering;

import java.awt.image.Kernel;

public class GaussianKernel
extends Kernel {
    public GaussianKernel(int radius, double sigma) {
        super(radius * 2 + 1, radius * 2 + 1, GaussianKernel.createKernel(radius, sigma));
    }

    private static float[] createKernel(int radius, double sigma) {
        int diameter = radius * 2 + 1;
        float[] data = new float[diameter * diameter];
        double sigma22 = 2.0 * sigma * sigma;
        double constant = Math.PI * sigma22;
        for (int y2 = -radius; y2 <= radius; ++y2) {
            for (int x2 = -radius; x2 <= radius; ++x2) {
                data[(y2 + radius) * diameter + x2 + radius] = (float)(Math.exp((double)(-(x2 * x2 + y2 * y2)) / sigma22) / constant);
            }
        }
        return data;
    }
}

