/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.filtering;

import java.awt.image.Kernel;

public class HeightMapFilter {
    private Kernel kernel;

    public HeightMapFilter(Kernel kernel) {
        this.kernel = kernel;
    }

    public HeightMapFilter(int kernelWidth, int kernelHeight, float[] kernelData) {
        this.kernel = new Kernel(kernelWidth, kernelHeight, kernelData);
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public int[] filter(int[] inData, int width, int height) {
        int index = 0;
        float[] matrix = this.kernel.getKernelData(null);
        int[] outData = new int[inData.length];
        int kh2 = this.kernel.getHeight();
        int kw2 = this.kernel.getWidth();
        int kox = this.kernel.getXOrigin();
        int koy = this.kernel.getYOrigin();
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                float z2 = 0.0f;
                for (int ky2 = 0; ky2 < kh2; ++ky2) {
                    int offsetY = y2 + ky2 - koy;
                    if (offsetY < 0 || offsetY >= height) {
                        offsetY = y2;
                    }
                    offsetY *= width;
                    int matrixOffset = ky2 * kw2;
                    for (int kx2 = 0; kx2 < kw2; ++kx2) {
                        float f2 = matrix[matrixOffset + kx2];
                        if (f2 == 0.0f) continue;
                        int offsetX = x2 + kx2 - kox;
                        if (offsetX < 0 || offsetX >= width) {
                            offsetX = x2;
                        }
                        z2 += f2 * (float)inData[offsetY + offsetX];
                    }
                }
                outData[index++] = (int)((double)z2 + 0.5);
            }
        }
        return outData;
    }
}

