/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.regions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import wecui.vendor.com.sk89q.worldedit.BlockVector;
import wecui.vendor.com.sk89q.worldedit.BlockVector2D;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.Vector2D;
import wecui.vendor.com.sk89q.worldedit.regions.AbstractRegion;
import wecui.vendor.com.sk89q.worldedit.regions.FlatRegion;
import wecui.vendor.com.sk89q.worldedit.regions.RegionOperationException;

public class CuboidRegion
extends AbstractRegion
implements FlatRegion {
    private Vector pos1;
    private Vector pos2;

    public CuboidRegion(Vector pos1, Vector pos2) {
        this(null, pos1, pos2);
    }

    public CuboidRegion(LocalWorld world, Vector pos1, Vector pos2) {
        super(world);
        this.pos1 = pos1;
        this.pos2 = pos2;
    }

    @Override
    public Vector getMinimumPoint() {
        return new Vector(Math.min(this.pos1.getX(), this.pos2.getX()), Math.min(this.pos1.getY(), this.pos2.getY()), Math.min(this.pos1.getZ(), this.pos2.getZ()));
    }

    @Override
    public Vector getMaximumPoint() {
        return new Vector(Math.max(this.pos1.getX(), this.pos2.getX()), Math.max(this.pos1.getY(), this.pos2.getY()), Math.max(this.pos1.getZ(), this.pos2.getZ()));
    }

    @Override
    public int getArea() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)((max.getX() - min.getX() + 1.0) * (max.getY() - min.getY() + 1.0) * (max.getZ() - min.getZ() + 1.0));
    }

    @Override
    public int getWidth() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)(max.getX() - min.getX() + 1.0);
    }

    @Override
    public int getHeight() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)(max.getY() - min.getY() + 1.0);
    }

    @Override
    public int getLength() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)(max.getZ() - min.getZ() + 1.0);
    }

    @Override
    public void expand(Vector ... changes) {
        for (Vector change : changes) {
            if (change.getX() > 0.0) {
                if (Math.max(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                    this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
                } else {
                    this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
                }
            } else if (Math.min(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
            }
            if (change.getY() > 0.0) {
                if (Math.max(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                    this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
                } else {
                    this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
                }
            } else if (Math.min(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
            }
            if (change.getZ() > 0.0) {
                if (Math.max(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                    this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
                    continue;
                }
                this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
                continue;
            }
            if (Math.min(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
                continue;
            }
            this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
        }
        this.recalculate();
    }

    @Override
    public void contract(Vector ... changes) {
        for (Vector change : changes) {
            if (change.getX() < 0.0) {
                if (Math.max(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                    this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
                } else {
                    this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
                }
            } else if (Math.min(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
            }
            if (change.getY() < 0.0) {
                if (Math.max(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                    this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
                } else {
                    this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
                }
            } else if (Math.min(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
            }
            if (change.getZ() < 0.0) {
                if (Math.max(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                    this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
                    continue;
                }
                this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
                continue;
            }
            if (Math.min(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
                continue;
            }
            this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
        }
        this.recalculate();
    }

    private void recalculate() {
        this.pos1 = this.pos1.clampY(0, this.world == null ? 255 : this.world.getMaxY());
        this.pos2 = this.pos2.clampY(0, this.world == null ? 255 : this.world.getMaxY());
    }

    @Override
    public void shift(Vector change) throws RegionOperationException {
        this.pos1 = this.pos1.add(change);
        this.pos2 = this.pos2.add(change);
        this.recalculate();
    }

    public Vector getPos1() {
        return this.pos1;
    }

    public void setPos1(Vector pos1) {
        this.pos1 = pos1;
    }

    public Vector getPos2() {
        return this.pos2;
    }

    public void setPos2(Vector pos2) {
        this.pos2 = pos2;
    }

    @Override
    public Set<com.sk89q.worldedit.Vector2D> getChunks() {
        HashSet<com.sk89q.worldedit.Vector2D> chunks = new HashSet<com.sk89q.worldedit.Vector2D>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        for (int x2 = min.getBlockX(); x2 <= max.getBlockX(); ++x2) {
            for (int z2 = min.getBlockZ(); z2 <= max.getBlockZ(); ++z2) {
                chunks.add((com.sk89q.worldedit.Vector2D)new BlockVector2D(x2 >> 4, z2 >> 4));
            }
        }
        return chunks;
    }

    @Override
    public Set<com.sk89q.worldedit.Vector> getChunkCubes() {
        HashSet<com.sk89q.worldedit.Vector> chunks = new HashSet<com.sk89q.worldedit.Vector>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        for (int x2 = min.getBlockX(); x2 <= max.getBlockX(); ++x2) {
            for (int y2 = min.getBlockY(); y2 <= max.getBlockY(); ++y2) {
                for (int z2 = min.getBlockZ(); z2 <= max.getBlockZ(); ++z2) {
                    chunks.add((com.sk89q.worldedit.Vector)new BlockVector(x2 >> 4, y2 >> 4, z2 >> 4));
                }
            }
        }
        return chunks;
    }

    @Override
    public boolean contains(Vector pt2) {
        double x2 = pt2.getX();
        double y2 = pt2.getY();
        double z2 = pt2.getZ();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return x2 >= (double)min.getBlockX() && x2 <= (double)max.getBlockX() && y2 >= (double)min.getBlockY() && y2 <= (double)max.getBlockY() && z2 >= (double)min.getBlockZ() && z2 <= (double)max.getBlockZ();
    }

    @Override
    public Iterator<com.sk89q.worldedit.BlockVector> iterator() {
        return new Iterator<com.sk89q.worldedit.BlockVector>(){
            private Vector min;
            private Vector max;
            private int nextX;
            private int nextY;
            private int nextZ;
            {
                this.min = CuboidRegion.this.getMinimumPoint();
                this.max = CuboidRegion.this.getMaximumPoint();
                this.nextX = this.min.getBlockX();
                this.nextY = this.min.getBlockY();
                this.nextZ = this.min.getBlockZ();
            }

            @Override
            public boolean hasNext() {
                return this.nextX != Integer.MIN_VALUE;
            }

            @Override
            public BlockVector next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BlockVector answer = new BlockVector(this.nextX, this.nextY, this.nextZ);
                if (++this.nextX > this.max.getBlockX()) {
                    this.nextX = this.min.getBlockX();
                    if (++this.nextY > this.max.getBlockY()) {
                        this.nextY = this.min.getBlockY();
                        if (++this.nextZ > this.max.getBlockZ()) {
                            this.nextX = Integer.MIN_VALUE;
                        }
                    }
                }
                return answer;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterable<com.sk89q.worldedit.Vector2D> asFlatRegion() {
        return new Iterable<com.sk89q.worldedit.Vector2D>(){

            @Override
            public Iterator<com.sk89q.worldedit.Vector2D> iterator() {
                return new Iterator<com.sk89q.worldedit.Vector2D>(){
                    private Vector min;
                    private Vector max;
                    private int nextX;
                    private int nextZ;
                    {
                        this.min = CuboidRegion.this.getMinimumPoint();
                        this.max = CuboidRegion.this.getMaximumPoint();
                        this.nextX = this.min.getBlockX();
                        this.nextZ = this.min.getBlockZ();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextX != Integer.MIN_VALUE;
                    }

                    @Override
                    public Vector2D next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Vector2D answer = new Vector2D(this.nextX, this.nextZ);
                        if (++this.nextX > this.max.getBlockX()) {
                            this.nextX = this.min.getBlockX();
                            if (++this.nextZ > this.max.getBlockZ()) {
                                this.nextX = Integer.MIN_VALUE;
                            }
                        }
                        return answer;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public String toString() {
        return this.getMinimumPoint() + " - " + this.getMaximumPoint();
    }

    @Override
    public CuboidRegion clone() {
        return (CuboidRegion)super.clone();
    }
}

