/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.regions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import wecui.vendor.com.sk89q.worldedit.BlockVector;
import wecui.vendor.com.sk89q.worldedit.BlockVector2D;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.Vector2D;
import wecui.vendor.com.sk89q.worldedit.regions.AbstractRegion;
import wecui.vendor.com.sk89q.worldedit.regions.FlatRegion;
import wecui.vendor.com.sk89q.worldedit.regions.FlatRegionIterator;
import wecui.vendor.com.sk89q.worldedit.regions.RegionOperationException;

public class CylinderRegion
extends AbstractRegion
implements FlatRegion {
    private Vector center;
    private Vector2D center2D;
    private Vector2D radius;
    private int minY;
    private int maxY;
    private boolean hasY = false;

    public CylinderRegion() {
        this((LocalWorld)null);
    }

    public CylinderRegion(LocalWorld world) {
        this(world, new Vector(), new Vector2D(), 0, 0);
        this.hasY = false;
    }

    public CylinderRegion(LocalWorld world, Vector center, Vector2D radius, int minY, int maxY) {
        super(world);
        this.setCenter(center);
        this.setRadius(radius);
        this.minY = minY;
        this.maxY = maxY;
        this.hasY = true;
    }

    public CylinderRegion(CylinderRegion region) {
        this(region.world, region.center, region.getRadius(), region.minY, region.maxY);
        this.hasY = region.hasY;
    }

    public Vector getCenter() {
        return this.center;
    }

    public void setCenter(Vector center) {
        this.center = center;
        this.center2D = center.toVector2D();
    }

    public Vector2D getRadius() {
        return this.radius.subtract(0.5, 0.5);
    }

    public void setRadius(Vector2D radius) {
        this.radius = radius.add(0.5, 0.5);
    }

    public void extendRadius(Vector2D minRadius) {
        this.setRadius(Vector2D.getMaximum(minRadius, this.getRadius()));
    }

    public void setMinimumY(int y2) {
        this.hasY = true;
        this.minY = y2;
    }

    public void setMaximumY(int y2) {
        this.hasY = true;
        this.maxY = y2;
    }

    @Override
    public Vector getMinimumPoint() {
        return this.center2D.subtract(this.getRadius()).toVector(this.minY);
    }

    @Override
    public Vector getMaximumPoint() {
        return this.center2D.add(this.getRadius()).toVector(this.maxY);
    }

    public int getMaximumY() {
        return this.maxY;
    }

    public int getMinimumY() {
        return this.minY;
    }

    @Override
    public int getArea() {
        return (int)Math.floor(this.radius.getX() * this.radius.getZ() * Math.PI * (double)this.getHeight());
    }

    @Override
    public int getWidth() {
        return (int)(2.0 * this.radius.getX());
    }

    @Override
    public int getHeight() {
        return this.maxY - this.minY + 1;
    }

    @Override
    public int getLength() {
        return (int)(2.0 * this.radius.getZ());
    }

    private Vector2D calculateDiff2D(Vector ... changes) throws RegionOperationException {
        Vector2D diff = new Vector2D();
        for (Vector change : changes) {
            diff = diff.add(change.toVector2D());
        }
        if ((diff.getBlockX() & 1) + (diff.getBlockZ() & 1) != 0) {
            throw new RegionOperationException("Cylinders changes must be even for each horizontal dimensions.");
        }
        return diff.divide(2).floor();
    }

    private Vector2D calculateChanges2D(Vector ... changes) {
        Vector2D total = new Vector2D();
        for (Vector change : changes) {
            total = total.add(change.toVector2D().positive());
        }
        return total.divide(2).floor();
    }

    @Override
    public void expand(Vector ... changes) throws RegionOperationException {
        this.setCenter(this.getCenter().add(this.calculateDiff2D(changes).toVector()));
        this.radius = this.radius.add(this.calculateChanges2D(changes));
        for (Vector change : changes) {
            int changeY = change.getBlockY();
            if (changeY > 0) {
                this.maxY += changeY;
                continue;
            }
            this.minY += changeY;
        }
    }

    @Override
    public void contract(Vector ... changes) throws RegionOperationException {
        this.setCenter(this.getCenter().subtract(this.calculateDiff2D(changes).toVector()));
        Vector2D newRadius = this.radius.subtract(this.calculateChanges2D(changes));
        this.radius = Vector2D.getMaximum(new Vector2D(1.5, 1.5), newRadius);
        for (Vector change : changes) {
            int changeY = change.getBlockY();
            if (changeY > 0) {
                this.minY += changeY;
                continue;
            }
            this.maxY += changeY;
        }
    }

    @Override
    public void shift(Vector change) throws RegionOperationException {
        this.setCenter(this.getCenter().add(change));
        int changeY = change.getBlockY();
        this.maxY += changeY;
        this.minY += changeY;
    }

    @Override
    public boolean contains(Vector pt2) {
        int blockY = pt2.getBlockY();
        if (blockY < this.minY || blockY > this.maxY) {
            return false;
        }
        return pt2.toVector2D().subtract(this.center2D).divide(this.radius).lengthSq() <= 1.0;
    }

    @Override
    public Set<com.sk89q.worldedit.Vector2D> getChunks() {
        HashSet<com.sk89q.worldedit.Vector2D> chunks = new HashSet<com.sk89q.worldedit.Vector2D>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        for (int x2 = min.getBlockX(); x2 <= max.getBlockX(); ++x2) {
            for (int z2 = min.getBlockZ(); z2 <= max.getBlockZ(); ++z2) {
                if (!this.contains(new BlockVector(x2, this.minY, z2))) continue;
                chunks.add((com.sk89q.worldedit.Vector2D)new BlockVector2D(x2 >> 4, z2 >> 4));
            }
        }
        return chunks;
    }

    @Override
    public Set<com.sk89q.worldedit.Vector> getChunkCubes() {
        HashSet<com.sk89q.worldedit.Vector> chunks = new HashSet<com.sk89q.worldedit.Vector>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        for (int x2 = min.getBlockX(); x2 <= max.getBlockX(); ++x2) {
            for (int y2 = min.getBlockY(); y2 <= max.getBlockY(); ++y2) {
                for (int z2 = min.getBlockZ(); z2 <= max.getBlockZ(); ++z2) {
                    if (!this.contains(new BlockVector(x2, y2, z2))) continue;
                    chunks.add((com.sk89q.worldedit.Vector)new BlockVector(x2 >> 4, y2 >> 4, z2 >> 4));
                }
            }
        }
        return chunks;
    }

    public boolean setY(int y2) {
        if (!this.hasY) {
            this.minY = y2;
            this.maxY = y2;
            this.hasY = true;
            return true;
        }
        if (y2 < this.minY) {
            this.minY = y2;
            return true;
        }
        if (y2 > this.maxY) {
            this.maxY = y2;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<com.sk89q.worldedit.Vector2D> asFlatRegion() {
        return new Iterable<com.sk89q.worldedit.Vector2D>(){

            @Override
            public Iterator<com.sk89q.worldedit.Vector2D> iterator() {
                return new FlatRegionIterator(CylinderRegion.this);
            }
        };
    }

    public String toString() {
        return this.center + " - " + this.radius;
    }

    @Override
    public CylinderRegion clone() {
        return (CylinderRegion)super.clone();
    }
}

