/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.regions;

import com.sk89q.worldedit.Vector2D;
import java.util.HashSet;
import java.util.Set;
import wecui.vendor.com.sk89q.worldedit.BlockVector;
import wecui.vendor.com.sk89q.worldedit.BlockVector2D;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.regions.AbstractRegion;
import wecui.vendor.com.sk89q.worldedit.regions.RegionOperationException;

public class EllipsoidRegion
extends AbstractRegion {
    private Vector center;
    private Vector radius;

    public EllipsoidRegion(Vector pos1, Vector pos2) {
        this(null, pos1, pos2);
    }

    public EllipsoidRegion(LocalWorld world, Vector center, Vector radius) {
        super(world);
        this.center = center;
        this.setRadius(radius);
    }

    public EllipsoidRegion(EllipsoidRegion ellipsoidRegion) {
        this(ellipsoidRegion.world, ellipsoidRegion.center, ellipsoidRegion.getRadius());
    }

    @Override
    public Vector getMinimumPoint() {
        return this.center.subtract(this.getRadius());
    }

    @Override
    public Vector getMaximumPoint() {
        return this.center.add(this.getRadius());
    }

    @Override
    public int getArea() {
        return (int)Math.floor(4.1887902047863905 * this.radius.getX() * this.radius.getY() * this.radius.getZ());
    }

    @Override
    public int getWidth() {
        return (int)(2.0 * this.radius.getX());
    }

    @Override
    public int getHeight() {
        return (int)(2.0 * this.radius.getY());
    }

    @Override
    public int getLength() {
        return (int)(2.0 * this.radius.getZ());
    }

    private Vector calculateDiff(Vector ... changes) throws RegionOperationException {
        Vector diff = new Vector().add(changes);
        if ((diff.getBlockX() & 1) + (diff.getBlockY() & 1) + (diff.getBlockZ() & 1) != 0) {
            throw new RegionOperationException("Ellipsoid changes must be even for each dimensions.");
        }
        return diff.divide(2).floor();
    }

    private Vector calculateChanges(Vector ... changes) {
        Vector total = new Vector();
        for (Vector change : changes) {
            total = total.add(change.positive());
        }
        return total.divide(2).floor();
    }

    @Override
    public void expand(Vector ... changes) throws RegionOperationException {
        this.center = this.center.add(this.calculateDiff(changes));
        this.radius = this.radius.add(this.calculateChanges(changes));
    }

    @Override
    public void contract(Vector ... changes) throws RegionOperationException {
        this.center = this.center.subtract(this.calculateDiff(changes));
        Vector newRadius = this.radius.subtract(this.calculateChanges(changes));
        this.radius = Vector.getMaximum(new Vector(1.5, 1.5, 1.5), newRadius);
    }

    @Override
    public void shift(Vector change) throws RegionOperationException {
        this.center = this.center.add(change);
    }

    public Vector getCenter() {
        return this.center;
    }

    public void setCenter(Vector center) {
        this.center = center;
    }

    public Vector getRadius() {
        return this.radius.subtract(0.5, 0.5, 0.5);
    }

    public void setRadius(Vector radius) {
        this.radius = radius.add(0.5, 0.5, 0.5);
    }

    @Override
    public Set<Vector2D> getChunks() {
        HashSet<Vector2D> chunks = new HashSet<Vector2D>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        for (int x2 = min.getBlockX(); x2 <= max.getBlockX(); ++x2) {
            for (int y2 = min.getBlockY(); y2 <= max.getBlockY(); ++y2) {
                for (int z2 = min.getBlockZ(); z2 <= max.getBlockZ(); ++z2) {
                    if (!this.contains(new BlockVector(x2, y2, z2))) continue;
                    chunks.add((Vector2D)new BlockVector2D(x2 >> 4, z2 >> 4));
                }
            }
        }
        return chunks;
    }

    @Override
    public Set<com.sk89q.worldedit.Vector> getChunkCubes() {
        HashSet<com.sk89q.worldedit.Vector> chunks = new HashSet<com.sk89q.worldedit.Vector>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        for (int x2 = min.getBlockX(); x2 <= max.getBlockX(); ++x2) {
            for (int y2 = min.getBlockY(); y2 <= max.getBlockY(); ++y2) {
                for (int z2 = min.getBlockZ(); z2 <= max.getBlockZ(); ++z2) {
                    if (!this.contains(new BlockVector(x2, y2, z2))) continue;
                    chunks.add((com.sk89q.worldedit.Vector)new BlockVector(x2 >> 4, y2 >> 4, z2 >> 4));
                }
            }
        }
        return chunks;
    }

    @Override
    public boolean contains(Vector pt2) {
        return pt2.subtract(this.center).divide(this.radius).lengthSq() <= 1.0;
    }

    public String toString() {
        return this.center + " - " + this.getRadius();
    }

    public void extendRadius(Vector minRadius) {
        this.setRadius(Vector.getMaximum(minRadius, this.getRadius()));
    }

    @Override
    public EllipsoidRegion clone() {
        return (EllipsoidRegion)super.clone();
    }
}

