/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.regions;

import java.util.ArrayList;
import java.util.List;
import wecui.vendor.com.sk89q.worldedit.BlockVector;
import wecui.vendor.com.sk89q.worldedit.IncompleteRegionException;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.cui.CUIRegion;
import wecui.vendor.com.sk89q.worldedit.cui.SelectionEllipsoidPointEvent;
import wecui.vendor.com.sk89q.worldedit.cui.SelectionPointEvent;
import wecui.vendor.com.sk89q.worldedit.regions.EllipsoidRegion;
import wecui.vendor.com.sk89q.worldedit.regions.Region;
import wecui.vendor.com.sk89q.worldedit.regions.RegionSelector;

public class EllipsoidRegionSelector
implements RegionSelector,
CUIRegion {
    protected EllipsoidRegion region;

    public EllipsoidRegionSelector(LocalWorld world) {
        this.region = new EllipsoidRegion(world, new Vector(), new Vector());
    }

    public EllipsoidRegionSelector() {
        this((LocalWorld)null);
    }

    public EllipsoidRegionSelector(RegionSelector oldSelector) {
        this(oldSelector.getIncompleteRegion().getWorld());
        if (oldSelector instanceof EllipsoidRegionSelector) {
            EllipsoidRegionSelector ellipsoidRegionSelector = (EllipsoidRegionSelector)oldSelector;
            this.region = new EllipsoidRegion(ellipsoidRegionSelector.getIncompleteRegion());
        } else {
            Region oldRegion = null;
            try {
                oldRegion = oldSelector.getRegion();
            }
            catch (IncompleteRegionException e2) {
                return;
            }
            BlockVector pos1 = oldRegion.getMinimumPoint().toBlockVector();
            BlockVector pos2 = oldRegion.getMaximumPoint().toBlockVector();
            Vector center = pos1.add((Vector)pos2).divide(2).floor();
            this.region.setCenter(center);
            this.region.setRadius(pos2.subtract(center));
        }
    }

    @Override
    public boolean selectPrimary(Vector pos) {
        if (pos.equals(this.region.getCenter()) && this.region.getRadius().lengthSq() == 0.0) {
            return false;
        }
        this.region.setCenter(pos.toBlockVector());
        this.region.setRadius(new Vector());
        return true;
    }

    @Override
    public boolean selectSecondary(Vector pos) {
        Vector diff = pos.subtract(this.region.getCenter());
        Vector minRadius = Vector.getMaximum(diff, diff.multiply(-1.0));
        this.region.extendRadius(minRadius);
        return true;
    }

    @Override
    public void explainPrimarySelection(LocalPlayer player, LocalSession session, Vector pos) {
        if (this.isDefined()) {
            player.print("Center position set to " + this.region.getCenter() + " (" + this.region.getArea() + ").");
        } else {
            player.print("Center position set to " + this.region.getCenter() + ".");
        }
        session.describeCUI(player);
    }

    @Override
    public void explainSecondarySelection(LocalPlayer player, LocalSession session, Vector pos) {
        if (this.isDefined()) {
            player.print("Radius set to " + this.region.getRadius() + " (" + this.region.getArea() + ").");
        } else {
            player.print("Radius set to " + this.region.getRadius() + ".");
        }
        session.describeCUI(player);
    }

    @Override
    public void explainRegionAdjust(LocalPlayer player, LocalSession session) {
        session.describeCUI(player);
    }

    @Override
    public boolean isDefined() {
        return this.region.getRadius().lengthSq() > 0.0;
    }

    @Override
    public EllipsoidRegion getRegion() throws IncompleteRegionException {
        if (!this.isDefined()) {
            throw new IncompleteRegionException();
        }
        return this.region;
    }

    @Override
    public EllipsoidRegion getIncompleteRegion() {
        return this.region;
    }

    @Override
    public void learnChanges() {
    }

    @Override
    public void clear() {
        this.region.setCenter(new Vector());
        this.region.setRadius(new Vector());
    }

    @Override
    public String getTypeName() {
        return "ellipsoid";
    }

    @Override
    public List<String> getInformationLines() {
        Vector radius;
        ArrayList<String> lines = new ArrayList<String>();
        Vector center = this.region.getCenter();
        if (center.lengthSq() > 0.0) {
            lines.add("Center: " + center);
        }
        if ((radius = this.region.getRadius()).lengthSq() > 0.0) {
            lines.add("X/Y/Z radius: " + radius);
        }
        return lines;
    }

    @Override
    public int getArea() {
        return this.region.getArea();
    }

    @Override
    public void describeCUI(LocalSession session, LocalPlayer player) {
        session.dispatchCUIEvent(player, new SelectionEllipsoidPointEvent(0, this.region.getCenter()));
        session.dispatchCUIEvent(player, new SelectionEllipsoidPointEvent(1, this.region.getRadius()));
    }

    @Override
    public void describeLegacyCUI(LocalSession session, LocalPlayer player) {
        session.dispatchCUIEvent(player, new SelectionPointEvent(0, this.region.getMinimumPoint(), this.getArea()));
        session.dispatchCUIEvent(player, new SelectionPointEvent(1, this.region.getMaximumPoint(), this.getArea()));
    }

    @Override
    public String getLegacyTypeID() {
        return "cuboid";
    }

    @Override
    public int getProtocolVersion() {
        return 1;
    }

    @Override
    public String getTypeID() {
        return "ellipsoid";
    }

    @Override
    public BlockVector getPrimaryPosition() throws IncompleteRegionException {
        return this.region.getCenter().toBlockVector();
    }
}

