/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.regions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import wecui.vendor.com.sk89q.worldedit.BlockVector;
import wecui.vendor.com.sk89q.worldedit.BlockVector2D;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.Vector2D;
import wecui.vendor.com.sk89q.worldedit.regions.AbstractRegion;
import wecui.vendor.com.sk89q.worldedit.regions.FlatRegion;
import wecui.vendor.com.sk89q.worldedit.regions.FlatRegionIterator;
import wecui.vendor.com.sk89q.worldedit.regions.RegionIterator;
import wecui.vendor.com.sk89q.worldedit.regions.RegionOperationException;

public class Polygonal2DRegion
extends AbstractRegion
implements FlatRegion {
    private List<com.sk89q.worldedit.BlockVector2D> points;
    private Vector2D min;
    private Vector2D max;
    private int minY;
    private int maxY;
    private boolean hasY = false;

    public Polygonal2DRegion() {
        this((LocalWorld)null);
    }

    public Polygonal2DRegion(LocalWorld world) {
        this(world, Collections.emptyList(), 0, 0);
        this.hasY = false;
    }

    public Polygonal2DRegion(LocalWorld world, List<com.sk89q.worldedit.BlockVector2D> points, int minY, int maxY) {
        super(world);
        this.points = new ArrayList<com.sk89q.worldedit.BlockVector2D>(points);
        this.minY = minY;
        this.maxY = maxY;
        this.hasY = true;
        this.recalculate();
    }

    public Polygonal2DRegion(Polygonal2DRegion region) {
        this(region.world, region.points, region.minY, region.maxY);
        this.hasY = region.hasY;
    }

    public List<com.sk89q.worldedit.BlockVector2D> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    protected void recalculate() {
        if (this.points.size() == 0) {
            this.min = new Vector2D(0, 0);
            this.minY = 0;
            this.max = new Vector2D(0, 0);
            this.maxY = 0;
            return;
        }
        int minX = ((BlockVector2D)this.points.get(0)).getBlockX();
        int minZ = ((BlockVector2D)this.points.get(0)).getBlockZ();
        int maxX = ((BlockVector2D)this.points.get(0)).getBlockX();
        int maxZ = ((BlockVector2D)this.points.get(0)).getBlockZ();
        for (BlockVector2D blockVector2D : this.points) {
            int x2 = blockVector2D.getBlockX();
            int z2 = blockVector2D.getBlockZ();
            if (x2 < minX) {
                minX = x2;
            }
            if (z2 < minZ) {
                minZ = z2;
            }
            if (x2 > maxX) {
                maxX = x2;
            }
            if (z2 <= maxZ) continue;
            maxZ = z2;
        }
        int oldMinY = this.minY;
        int n2 = this.maxY;
        this.minY = Math.min(oldMinY, n2);
        this.maxY = Math.max(oldMinY, n2);
        this.minY = Math.min(Math.max(0, this.minY), this.world == null ? 255 : this.world.getMaxY());
        this.maxY = Math.min(Math.max(0, this.maxY), this.world == null ? 255 : this.world.getMaxY());
        this.min = new Vector2D(minX, minZ);
        this.max = new Vector2D(maxX, maxZ);
    }

    public void addPoint(Vector2D pt2) {
        this.points.add((com.sk89q.worldedit.BlockVector2D)pt2.toBlockVector2D());
        this.recalculate();
    }

    public void addPoint(BlockVector2D pt2) {
        this.points.add((com.sk89q.worldedit.BlockVector2D)pt2);
        this.recalculate();
    }

    public void addPoint(Vector pt2) {
        this.points.add((com.sk89q.worldedit.BlockVector2D)new BlockVector2D(pt2.getBlockX(), pt2.getBlockZ()));
        this.recalculate();
    }

    public int getMininumY() {
        return this.minY;
    }

    public void setMinimumY(int y2) {
        this.hasY = true;
        this.minY = y2;
        this.recalculate();
    }

    public int getMaximumY() {
        return this.maxY;
    }

    public void setMaximumY(int y2) {
        this.hasY = true;
        this.maxY = y2;
        this.recalculate();
    }

    @Override
    public Vector getMinimumPoint() {
        return this.min.toVector(this.minY);
    }

    @Override
    public Vector getMaximumPoint() {
        return this.max.toVector(this.maxY);
    }

    @Override
    public int getArea() {
        double area = 0.0;
        int j2 = this.points.size() - 1;
        int i2 = 0;
        while (i2 < this.points.size()) {
            area += (double)((((BlockVector2D)this.points.get(j2)).getBlockX() + ((BlockVector2D)this.points.get(i2)).getBlockX()) * (((BlockVector2D)this.points.get(j2)).getBlockZ() - ((BlockVector2D)this.points.get(i2)).getBlockZ()));
            j2 = i2++;
        }
        return (int)Math.floor(Math.abs(area * 0.5) * (double)(this.maxY - this.minY + 1));
    }

    @Override
    public int getWidth() {
        return this.max.getBlockX() - this.min.getBlockX();
    }

    @Override
    public int getHeight() {
        return this.maxY - this.minY;
    }

    @Override
    public int getLength() {
        return this.max.getBlockZ() - this.min.getBlockZ();
    }

    @Override
    public void expand(Vector ... changes) throws RegionOperationException {
        for (Vector change : changes) {
            if (change.getBlockX() == 0 && change.getBlockZ() == 0) continue;
            throw new RegionOperationException("Polygons can only be expanded vertically.");
        }
        for (Vector change : changes) {
            int changeY = change.getBlockY();
            if (changeY > 0) {
                this.maxY += changeY;
                continue;
            }
            this.minY += changeY;
        }
        this.recalculate();
    }

    @Override
    public void contract(Vector ... changes) throws RegionOperationException {
        for (Vector change : changes) {
            if (change.getBlockX() == 0 && change.getBlockZ() == 0) continue;
            throw new RegionOperationException("Polygons can only be contracted vertically.");
        }
        for (Vector change : changes) {
            int changeY = change.getBlockY();
            if (changeY > 0) {
                this.minY += changeY;
                continue;
            }
            this.maxY += changeY;
        }
        this.recalculate();
    }

    @Override
    public void shift(Vector change) throws RegionOperationException {
        double changeX = change.getX();
        double changeY = change.getY();
        double changeZ = change.getZ();
        for (int i2 = 0; i2 < this.points.size(); ++i2) {
            BlockVector2D point = (BlockVector2D)this.points.get(i2);
            this.points.set(i2, (com.sk89q.worldedit.BlockVector2D)new BlockVector2D(point.getX() + changeX, point.getZ() + changeZ));
        }
        this.minY = (int)((double)this.minY + changeY);
        this.maxY = (int)((double)this.maxY + changeY);
        this.recalculate();
    }

    @Override
    public boolean contains(Vector pt2) {
        return Polygonal2DRegion.contains(this.points, this.minY, this.maxY, pt2);
    }

    public static boolean contains(List<com.sk89q.worldedit.BlockVector2D> points, int minY, int maxY, Vector pt2) {
        if (points.size() < 3) {
            return false;
        }
        int targetX = pt2.getBlockX();
        int targetY = pt2.getBlockY();
        int targetZ = pt2.getBlockZ();
        if (targetY < minY || targetY > maxY) {
            return false;
        }
        boolean inside = false;
        int npoints = points.size();
        int xOld = ((BlockVector2D)points.get(npoints - 1)).getBlockX();
        int zOld = ((BlockVector2D)points.get(npoints - 1)).getBlockZ();
        for (int i2 = 0; i2 < npoints; ++i2) {
            int z2;
            int z1;
            int x2;
            int x1;
            int xNew = ((BlockVector2D)points.get(i2)).getBlockX();
            int zNew = ((BlockVector2D)points.get(i2)).getBlockZ();
            if (xNew == targetX && zNew == targetZ) {
                return true;
            }
            if (xNew > xOld) {
                x1 = xOld;
                x2 = xNew;
                z1 = zOld;
                z2 = zNew;
            } else {
                x1 = xNew;
                x2 = xOld;
                z1 = zNew;
                z2 = zOld;
            }
            if (x1 <= targetX && targetX <= x2) {
                long crossproduct = ((long)targetZ - (long)z1) * (long)(x2 - x1) - ((long)z2 - (long)z1) * (long)(targetX - x1);
                if (crossproduct == 0L) {
                    if (z1 <= targetZ == targetZ <= z2) {
                        return true;
                    }
                } else if (crossproduct < 0L && x1 != targetX) {
                    inside = !inside;
                }
            }
            xOld = xNew;
            zOld = zNew;
        }
        return inside;
    }

    @Override
    public Set<com.sk89q.worldedit.Vector2D> getChunks() {
        HashSet<com.sk89q.worldedit.Vector2D> chunks = new HashSet<com.sk89q.worldedit.Vector2D>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        for (int x2 = min.getBlockX(); x2 <= max.getBlockX(); ++x2) {
            for (int z2 = min.getBlockZ(); z2 <= max.getBlockZ(); ++z2) {
                if (!this.contains(new BlockVector(x2, this.minY, z2))) continue;
                chunks.add((com.sk89q.worldedit.Vector2D)new BlockVector2D(x2 >> 4, z2 >> 4));
            }
        }
        return chunks;
    }

    @Override
    public Set<com.sk89q.worldedit.Vector> getChunkCubes() {
        HashSet<com.sk89q.worldedit.Vector> chunks = new HashSet<com.sk89q.worldedit.Vector>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        for (int x2 = min.getBlockX(); x2 <= max.getBlockX(); ++x2) {
            for (int y2 = min.getBlockY(); y2 <= max.getBlockY(); ++y2) {
                for (int z2 = min.getBlockZ(); z2 <= max.getBlockZ(); ++z2) {
                    if (!this.contains(new BlockVector(x2, y2, z2))) continue;
                    chunks.add((com.sk89q.worldedit.Vector)new BlockVector(x2 >> 4, y2 >> 4, z2 >> 4));
                }
            }
        }
        return chunks;
    }

    public int size() {
        return this.points.size();
    }

    public boolean expandY(int y2) {
        if (!this.hasY) {
            this.minY = y2;
            this.maxY = y2;
            this.hasY = true;
            return true;
        }
        if (y2 < this.minY) {
            this.minY = y2;
            return true;
        }
        if (y2 > this.maxY) {
            this.maxY = y2;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<com.sk89q.worldedit.BlockVector> iterator() {
        return new RegionIterator(this);
    }

    @Override
    public Iterable<com.sk89q.worldedit.Vector2D> asFlatRegion() {
        return new Iterable<com.sk89q.worldedit.Vector2D>(){

            @Override
            public Iterator<com.sk89q.worldedit.Vector2D> iterator() {
                return new FlatRegionIterator(Polygonal2DRegion.this);
            }
        };
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        List<com.sk89q.worldedit.BlockVector2D> pts = this.getPoints();
        Iterator<com.sk89q.worldedit.BlockVector2D> it2 = pts.iterator();
        while (it2.hasNext()) {
            BlockVector2D current = (BlockVector2D)it2.next();
            sb2.append("(" + current.getBlockX() + ", " + current.getBlockZ() + ")");
            if (!it2.hasNext()) continue;
            sb2.append(" - ");
        }
        sb2.append(" * (" + this.minY + " - " + this.maxY + ")");
        return sb2.toString();
    }

    @Override
    public Polygonal2DRegion clone() {
        Polygonal2DRegion clone = (Polygonal2DRegion)super.clone();
        clone.points = new ArrayList<com.sk89q.worldedit.BlockVector2D>(this.points);
        return clone;
    }
}

