/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.schematic;

import com.sk89q.jnbt.Tag;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import wecui.vendor.com.sk89q.jnbt.ByteArrayTag;
import wecui.vendor.com.sk89q.jnbt.CompoundTag;
import wecui.vendor.com.sk89q.jnbt.IntTag;
import wecui.vendor.com.sk89q.jnbt.ListTag;
import wecui.vendor.com.sk89q.jnbt.NBTConstants;
import wecui.vendor.com.sk89q.jnbt.NBTInputStream;
import wecui.vendor.com.sk89q.jnbt.NBTOutputStream;
import wecui.vendor.com.sk89q.jnbt.ShortTag;
import wecui.vendor.com.sk89q.jnbt.StringTag;
import wecui.vendor.com.sk89q.worldedit.BlockVector;
import wecui.vendor.com.sk89q.worldedit.CuboidClipboard;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.blocks.TileEntityBlock;
import wecui.vendor.com.sk89q.worldedit.data.DataException;
import wecui.vendor.com.sk89q.worldedit.schematic.SchematicFormat;

public class MCEditSchematicFormat
extends SchematicFormat {
    private static final int MAX_SIZE = 65535;

    protected MCEditSchematicFormat() {
        super("MCEdit", "mcedit", "mce");
    }

    @Override
    public CuboidClipboard load(File file) throws IOException, DataException {
        FileInputStream stream = new FileInputStream(file);
        NBTInputStream nbtStream = new NBTInputStream(new GZIPInputStream(stream));
        Vector origin = new Vector();
        Vector offset = new Vector();
        CompoundTag schematicTag = (CompoundTag)nbtStream.readTag();
        if (!schematicTag.getName().equals("Schematic")) {
            throw new DataException("Tag \"Schematic\" does not exist or is not first");
        }
        Object schematic = schematicTag.getValue();
        if (!schematic.containsKey("Blocks")) {
            throw new DataException("Schematic file is missing a \"Blocks\" tag");
        }
        int width = MCEditSchematicFormat.getChildTag((Map<String, Tag>)schematic, "Width", ShortTag.class).getValue().shortValue();
        int length = MCEditSchematicFormat.getChildTag((Map<String, Tag>)schematic, "Length", ShortTag.class).getValue().shortValue();
        int height = MCEditSchematicFormat.getChildTag((Map<String, Tag>)schematic, "Height", ShortTag.class).getValue().shortValue();
        try {
            int originX = MCEditSchematicFormat.getChildTag((Map<String, Tag>)schematic, "WEOriginX", IntTag.class).getValue();
            int originY = MCEditSchematicFormat.getChildTag((Map<String, Tag>)schematic, "WEOriginY", IntTag.class).getValue();
            int originZ = MCEditSchematicFormat.getChildTag((Map<String, Tag>)schematic, "WEOriginZ", IntTag.class).getValue();
            origin = new Vector(originX, originY, originZ);
        }
        catch (DataException e2) {
            // empty catch block
        }
        try {
            int offsetX = MCEditSchematicFormat.getChildTag((Map<String, Tag>)schematic, "WEOffsetX", IntTag.class).getValue();
            int offsetY = MCEditSchematicFormat.getChildTag((Map<String, Tag>)schematic, "WEOffsetY", IntTag.class).getValue();
            int offsetZ = MCEditSchematicFormat.getChildTag((Map<String, Tag>)schematic, "WEOffsetZ", IntTag.class).getValue();
            offset = new Vector(offsetX, offsetY, offsetZ);
        }
        catch (DataException e3) {
            // empty catch block
        }
        String materials = MCEditSchematicFormat.getChildTag((Map<String, Tag>)schematic, "Materials", StringTag.class).getValue();
        if (!materials.equals("Alpha")) {
            throw new DataException("Schematic file is not an Alpha schematic");
        }
        byte[] blocks = MCEditSchematicFormat.getChildTag((Map<String, Tag>)schematic, "Blocks", ByteArrayTag.class).getValue();
        byte[] blockData = MCEditSchematicFormat.getChildTag((Map<String, Tag>)schematic, "Data", ByteArrayTag.class).getValue();
        Object tileEntities = MCEditSchematicFormat.getChildTag((Map<String, Tag>)schematic, "TileEntities", ListTag.class).getValue();
        HashMap tileEntitiesMap = new HashMap();
        Iterator i$ = tileEntities.iterator();
        while (i$.hasNext()) {
            wecui.vendor.com.sk89q.jnbt.Tag tag = (wecui.vendor.com.sk89q.jnbt.Tag)i$.next();
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag t2 = (CompoundTag)tag;
            int x2 = 0;
            int y2 = 0;
            int z2 = 0;
            HashMap values = new HashMap();
            for (Map.Entry entry : t2.getValue().entrySet()) {
                if (((String)entry.getKey()).equals("x")) {
                    if (entry.getValue() instanceof IntTag) {
                        x2 = ((IntTag)entry.getValue()).getValue();
                    }
                } else if (((String)entry.getKey()).equals("y")) {
                    if (entry.getValue() instanceof IntTag) {
                        y2 = ((IntTag)entry.getValue()).getValue();
                    }
                } else if (((String)entry.getKey()).equals("z") && entry.getValue() instanceof IntTag) {
                    z2 = ((IntTag)entry.getValue()).getValue();
                }
                values.put(entry.getKey(), entry.getValue());
            }
            BlockVector vec = new BlockVector(x2, y2, z2);
            tileEntitiesMap.put(vec, values);
        }
        Vector size = new Vector(width, height, length);
        CuboidClipboard clipboard = new CuboidClipboard(size);
        clipboard.setOrigin(origin);
        clipboard.setOffset(offset);
        for (int x3 = 0; x3 < width; ++x3) {
            for (int y3 = 0; y3 < height; ++y3) {
                for (int z3 = 0; z3 < length; ++z3) {
                    int index = y3 * width * length + z3 * width + x3;
                    BlockVector pt2 = new BlockVector(x3, y3, z3);
                    BaseBlock block = this.getBlockForId(blocks[index], blockData[index]);
                    if (block instanceof TileEntityBlock && tileEntitiesMap.containsKey(pt2)) {
                        ((TileEntityBlock)((Object)block)).fromTileEntityNBT((Map)tileEntitiesMap.get(pt2));
                    }
                    clipboard.setBlock(pt2, block);
                }
            }
        }
        return clipboard;
    }

    @Override
    public void save(CuboidClipboard clipboard, File file) throws IOException, DataException {
        int width = clipboard.getWidth();
        int height = clipboard.getHeight();
        int length = clipboard.getLength();
        if (width > 65535) {
            throw new DataException("Width of region too large for a .schematic");
        }
        if (height > 65535) {
            throw new DataException("Height of region too large for a .schematic");
        }
        if (length > 65535) {
            throw new DataException("Length of region too large for a .schematic");
        }
        HashMap<String, Tag> schematic = new HashMap<String, Tag>();
        schematic.put("Width", (Tag)new ShortTag("Width", (short)width));
        schematic.put("Length", (Tag)new ShortTag("Length", (short)length));
        schematic.put("Height", (Tag)new ShortTag("Height", (short)height));
        schematic.put("Materials", (Tag)new StringTag("Materials", "Alpha"));
        schematic.put("WEOriginX", (Tag)new IntTag("WEOriginX", clipboard.getOrigin().getBlockX()));
        schematic.put("WEOriginY", (Tag)new IntTag("WEOriginY", clipboard.getOrigin().getBlockY()));
        schematic.put("WEOriginZ", (Tag)new IntTag("WEOriginZ", clipboard.getOrigin().getBlockZ()));
        schematic.put("WEOffsetX", (Tag)new IntTag("WEOffsetX", clipboard.getOffset().getBlockX()));
        schematic.put("WEOffsetY", (Tag)new IntTag("WEOffsetY", clipboard.getOffset().getBlockY()));
        schematic.put("WEOffsetZ", (Tag)new IntTag("WEOffsetZ", clipboard.getOffset().getBlockZ()));
        byte[] blocks = new byte[width * height * length];
        byte[] blockData = new byte[width * height * length];
        ArrayList<CompoundTag> tileEntities = new ArrayList<CompoundTag>();
        for (int x2 = 0; x2 < width; ++x2) {
            for (int y2 = 0; y2 < height; ++y2) {
                for (int z2 = 0; z2 < length; ++z2) {
                    TileEntityBlock tileEntityBlock;
                    Map<String, Tag> values;
                    int index = y2 * width * length + z2 * width + x2;
                    BaseBlock block = clipboard.getPoint(new BlockVector(x2, y2, z2));
                    blocks[index] = (byte)block.getType();
                    blockData[index] = (byte)block.getData();
                    if (!(block instanceof TileEntityBlock) || (values = (tileEntityBlock = (TileEntityBlock)((Object)block)).toTileEntityNBT()) == null) continue;
                    values.put("id", (Tag)new StringTag("id", tileEntityBlock.getTileEntityID()));
                    values.put("x", (Tag)new IntTag("x", x2));
                    values.put("y", (Tag)new IntTag("y", y2));
                    values.put("z", (Tag)new IntTag("z", z2));
                    CompoundTag tileEntityTag = new CompoundTag("TileEntity", values);
                    tileEntities.add(tileEntityTag);
                }
            }
        }
        schematic.put("Blocks", (Tag)new ByteArrayTag("Blocks", blocks));
        schematic.put("Data", (Tag)new ByteArrayTag("Data", blockData));
        schematic.put("Entities", (Tag)new ListTag("Entities", CompoundTag.class, new ArrayList()));
        schematic.put("TileEntities", (Tag)new ListTag("TileEntities", CompoundTag.class, tileEntities));
        CompoundTag schematicTag = new CompoundTag("Schematic", schematic);
        NBTOutputStream stream = new NBTOutputStream(new FileOutputStream(file));
        stream.writeTag(schematicTag);
        stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOfFormat(File file) {
        boolean bl2;
        FilterInputStream str = null;
        try {
            str = new DataInputStream(new GZIPInputStream(new FileInputStream(file)));
            if ((((DataInputStream)str).readByte() & 0xFF) != 10) {
                boolean bl3 = false;
                return bl3;
            }
            byte[] nameBytes = new byte[((DataInputStream)str).readShort() & 0xFFFF];
            ((DataInputStream)str).readFully(nameBytes);
            String name = new String(nameBytes, NBTConstants.CHARSET);
            bl2 = name.equals("Schematic");
        }
        catch (IOException e2) {
            boolean bl4 = false;
            return bl4;
        }
        finally {
            if (str != null) {
                try {
                    str.close();
                }
                catch (IOException ignore) {}
            }
        }
        return bl2;
    }

    private static <T extends wecui.vendor.com.sk89q.jnbt.Tag> T getChildTag(Map<String, Tag> items, String key, Class<T> expected) throws DataException {
        if (!items.containsKey(key)) {
            throw new DataException("Schematic file is missing a \"" + key + "\" tag");
        }
        wecui.vendor.com.sk89q.jnbt.Tag tag = (wecui.vendor.com.sk89q.jnbt.Tag)items.get(key);
        if (!expected.isInstance(tag)) {
            throw new DataException(key + " tag is not of tag type " + expected.getName());
        }
        return (T)((wecui.vendor.com.sk89q.jnbt.Tag)expected.cast(tag));
    }
}

