/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.scripting;

import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;

public class RhinoContextFactory
extends ContextFactory {
    protected int timeLimit;

    public RhinoContextFactory(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    protected Context makeContext() {
        RhinoContext cx2 = new RhinoContext(this);
        cx2.setInstructionObserverThreshold(10000);
        return cx2;
    }

    protected void observeInstructionCount(Context cx2, int instructionCount) {
        RhinoContext mcx = (RhinoContext)cx2;
        long currentTime = System.currentTimeMillis();
        if (currentTime - mcx.startTime > (long)this.timeLimit) {
            throw new Error("Script timed out (" + this.timeLimit + "ms)");
        }
    }

    protected Object doTopCall(Callable callable, Context cx2, Scriptable scope, Scriptable thisObj, Object[] args) {
        RhinoContext mcx = (RhinoContext)cx2;
        mcx.startTime = System.currentTimeMillis();
        return super.doTopCall(callable, cx2, scope, thisObj, args);
    }

    private static class RhinoContext
    extends Context {
        long startTime;

        public RhinoContext(ContextFactory factory) {
            super(factory);
        }
    }
}

