/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.spout;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spout.api.Spout;
import org.spout.api.event.EventHandler;
import org.spout.api.event.Listener;
import org.spout.api.event.Order;
import org.spout.api.event.player.PlayerChatEvent;
import org.spout.api.event.player.PlayerInteractEvent;
import org.spout.api.event.player.PlayerJoinEvent;
import org.spout.api.event.player.PlayerLeaveEvent;
import org.spout.api.event.server.PreCommandEvent;
import org.spout.api.event.world.WorldLoadEvent;
import org.spout.api.generator.biome.BiomeGenerator;
import org.spout.api.geo.discrete.Point;
import org.spout.api.plugin.Plugin;
import wecui.vendor.com.sk89q.util.StringUtil;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.WorldEdit;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.spout.SpoutPlayer;
import wecui.vendor.com.sk89q.worldedit.spout.WorldEditPlugin;

public class WorldEditListener
implements Listener {
    private WorldEditPlugin plugin;
    private boolean ignoreLeftClickAir = false;
    private static final Pattern cuipattern = Pattern.compile("u00a74u00a75u00a73u00a74([^|]*)\\|?(.*)");

    public WorldEditListener(WorldEditPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(order=Order.EARLIEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.plugin.wrapPlayer(event.getPlayer()).dispatchCUIHandshake();
    }

    @EventHandler
    public void onPlayerQuit(PlayerLeaveEvent event) {
        this.plugin.getWorldEdit().markExpire(this.plugin.wrapPlayer(event.getPlayer()));
    }

    @EventHandler(order=Order.EARLY)
    public void onPlayerCommandPreprocess(PreCommandEvent event) {
        if (event.getMessage().startsWith("nowe:")) {
            event.setMessage(event.getMessage().substring(5));
            return;
        }
        String[] split = event.getMessage().split(" ");
        if (split.length > 0) {
            split[0] = "/" + split[0];
            split = this.plugin.getWorldEdit().commandDetection(split);
            event.setMessage(StringUtil.joinString(split, " "));
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        SpoutPlayer player = this.plugin.wrapPlayer(event.getPlayer());
        LocalWorld world = ((LocalPlayer)player).getWorld();
        WorldEdit we2 = this.plugin.getWorldEdit();
        PlayerInteractEvent.Action action = event.getAction();
        if (action == PlayerInteractEvent.Action.LEFT_CLICK) {
            int taskId;
            Point clickedBlock;
            WorldVector pos;
            if (event.isAir() && this.ignoreLeftClickAir) {
                return;
            }
            if (!event.isAir() && we2.handleBlockLeftClick(player, pos = new WorldVector(world, (clickedBlock = event.getInteractedPoint()).getX(), clickedBlock.getY(), clickedBlock.getZ()))) {
                event.setCancelled(true);
            }
            if (we2.handleArmSwing(player)) {
                event.setCancelled(true);
            }
            if (!event.isAir() && !this.ignoreLeftClickAir && (taskId = Spout.getGame().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    WorldEditListener.this.ignoreLeftClickAir = false;
                }
            }, 2L)) != -1) {
                this.ignoreLeftClickAir = true;
            }
        } else if (action == PlayerInteractEvent.Action.RIGHT_CLICK) {
            Point clickedBlock;
            WorldVector pos;
            if (!event.isAir() && we2.handleBlockRightClick(player, pos = new WorldVector(world, (clickedBlock = event.getInteractedPoint()).getX(), clickedBlock.getY(), clickedBlock.getZ()))) {
                event.setCancelled(true);
            }
            if (we2.handleRightClick(player)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerChat(PlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Matcher matcher = cuipattern.matcher(event.getMessage());
        if (matcher.find()) {
            String type = matcher.group(1);
            String args = matcher.group(2);
            if (type.equals("v")) {
                try {
                    this.plugin.getSession(event.getPlayer()).setCUIVersion(Integer.parseInt(args));
                    event.setCancelled(true);
                }
                catch (NumberFormatException e2) {
                    // empty catch block
                }
            }
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        if (event.getWorld().getGenerator() instanceof BiomeGenerator) {
            this.plugin.getServerInterface().getBiomes().registerBiomeTypes((BiomeGenerator)event.getWorld().getGenerator());
        }
    }
}

