/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.tools;

import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalConfiguration;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.MaxChangedBlocksException;
import wecui.vendor.com.sk89q.worldedit.ServerInterface;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.tools.BlockTool;

public class AreaPickaxe
implements BlockTool {
    private static final BaseBlock air = new BaseBlock(0);
    private int range;

    public AreaPickaxe(int range) {
        this.range = range;
    }

    @Override
    public boolean canUse(LocalPlayer player) {
        return player.hasPermission("worldedit.superpickaxe.area");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean actPrimary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session, WorldVector clicked) {
        LocalWorld world = clicked.getWorld();
        int ox2 = clicked.getBlockX();
        int oy2 = clicked.getBlockY();
        int oz2 = clicked.getBlockZ();
        int initialType = world.getBlockType(clicked);
        if (initialType == 0) {
            return true;
        }
        if (initialType == 7 && !player.canDestroyBedrock()) {
            return true;
        }
        EditSession editSession = session.createEditSession(player);
        try {
            for (int x2 = ox2 - this.range; x2 <= ox2 + this.range; ++x2) {
                for (int y2 = oy2 - this.range; y2 <= oy2 + this.range; ++y2) {
                    for (int z2 = oz2 - this.range; z2 <= oz2 + this.range; ++z2) {
                        Vector pos = new Vector(x2, y2, z2);
                        if (world.getBlockType(pos) != initialType) continue;
                        if (config.superPickaxeManyDrop) {
                            world.simulateBlockMine(pos);
                        }
                        world.queueBlockBreakEffect(server, pos, initialType, clicked.distanceSq(pos));
                        editSession.setBlock(pos, air);
                    }
                }
            }
        }
        catch (MaxChangedBlocksException e2) {
            player.printError("Max blocks change limit reached.");
        }
        finally {
            session.remember(editSession);
        }
        return true;
    }
}

