/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.tools;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalConfiguration;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.MaxChangedBlocksException;
import wecui.vendor.com.sk89q.worldedit.PlayerDirection;
import wecui.vendor.com.sk89q.worldedit.ServerInterface;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.tools.BlockTool;

public class FloatingTreeRemover
implements BlockTool {
    private static final BaseBlock AIR = new BaseBlock(0);
    private int rangeSq = 10000;
    Vector[] recurseDirections = new Vector[]{PlayerDirection.NORTH.vector(), PlayerDirection.EAST.vector(), PlayerDirection.SOUTH.vector(), PlayerDirection.WEST.vector(), PlayerDirection.UP.vector(), PlayerDirection.DOWN.vector()};

    @Override
    public boolean canUse(LocalPlayer player) {
        return player.hasPermission("worldedit.tool.deltree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean actPrimary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session, WorldVector clicked) {
        LocalWorld world = clicked.getWorld();
        switch (world.getBlockType(clicked)) {
            case 17: 
            case 18: 
            case 99: 
            case 100: 
            case 106: {
                break;
            }
            default: {
                player.printError("That's not a tree.");
                return true;
            }
        }
        EditSession editSession = session.createEditSession(player);
        try {
            Set<com.sk89q.worldedit.Vector> blockSet = this.bfs(world, clicked);
            if (blockSet == null) {
                player.printError("That's not a floating tree.");
                boolean bl2 = true;
                return bl2;
            }
            for (Vector vector : blockSet) {
                int typeId = editSession.getBlock(vector).getType();
                switch (typeId) {
                    case 17: 
                    case 18: 
                    case 99: 
                    case 100: 
                    case 106: {
                        editSession.setBlock(vector, AIR);
                    }
                }
            }
        }
        catch (MaxChangedBlocksException e2) {
            player.printError("Max blocks change limit reached.");
        }
        finally {
            session.remember(editSession);
        }
        return true;
    }

    private Set<com.sk89q.worldedit.Vector> bfs(LocalWorld world, Vector origin) throws MaxChangedBlocksException {
        HashSet<com.sk89q.worldedit.Vector> visited = new HashSet<com.sk89q.worldedit.Vector>();
        LinkedList<Vector> queue = new LinkedList<Vector>();
        queue.addLast(origin);
        visited.add((com.sk89q.worldedit.Vector)origin);
        while (!queue.isEmpty()) {
            Vector current = (Vector)queue.removeFirst();
            block5: for (Vector recurseDirection : this.recurseDirections) {
                Vector next = current.add(recurseDirection);
                if (origin.distanceSq(next) > (double)this.rangeSq || !visited.add((com.sk89q.worldedit.Vector)next)) continue;
                switch (world.getBlockType(next)) {
                    case 0: 
                    case 78: {
                        continue block5;
                    }
                    case 17: 
                    case 18: 
                    case 99: 
                    case 100: 
                    case 106: {
                        queue.addLast(next);
                        continue block5;
                    }
                    default: {
                        int curId = world.getBlockType(current);
                        if (curId == 18 || curId == 106) continue block5;
                        return null;
                    }
                }
            }
        }
        return visited;
    }
}

