/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.tools;

import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalConfiguration;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.MaxChangedBlocksException;
import wecui.vendor.com.sk89q.worldedit.ServerInterface;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.WorldVectorFace;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.tools.BrushTool;
import wecui.vendor.com.sk89q.worldedit.tools.DoubleActionTraceTool;

public class LongRangeBuildTool
extends BrushTool
implements DoubleActionTraceTool {
    BaseBlock primary;
    BaseBlock secondary;

    public LongRangeBuildTool(BaseBlock primary, BaseBlock secondary) {
        super("worldedit.tool.lrbuild");
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public boolean canUse(LocalPlayer player) {
        return player.hasPermission("worldedit.tool.lrbuild");
    }

    @Override
    public boolean actSecondary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session) {
        WorldVectorFace pos = this.getTargetFace(player);
        if (pos == null) {
            return false;
        }
        EditSession eS = session.createEditSession(player);
        try {
            if (this.secondary.getType() == 0) {
                eS.setBlock((Vector)pos, this.secondary);
            } else {
                eS.setBlock((Vector)pos.getFaceVector(), this.secondary);
            }
            return true;
        }
        catch (MaxChangedBlocksException e2) {
            return false;
        }
    }

    @Override
    public boolean actPrimary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session) {
        WorldVectorFace pos = this.getTargetFace(player);
        if (pos == null) {
            return false;
        }
        EditSession eS = session.createEditSession(player);
        try {
            if (this.primary.getType() == 0) {
                eS.setBlock((Vector)pos, this.primary);
            } else {
                eS.setBlock((Vector)pos.getFaceVector(), this.primary);
            }
            return true;
        }
        catch (MaxChangedBlocksException e2) {
            return false;
        }
    }

    public WorldVectorFace getTargetFace(LocalPlayer player) {
        WorldVectorFace target = null;
        target = player.getBlockTraceFace(this.getRange(), true);
        if (target == null) {
            player.printError("No block in sight!");
            return null;
        }
        return target;
    }
}

