/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.tools.brushes;

import java.util.ArrayList;
import java.util.Collections;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.MaxChangedBlocksException;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.patterns.Pattern;
import wecui.vendor.com.sk89q.worldedit.tools.brushes.Brush;

public class GravityBrush
implements Brush {
    private final boolean fullHeight;

    public GravityBrush(boolean fullHeight) {
        this.fullHeight = fullHeight;
    }

    @Override
    public void build(EditSession editSession, Vector pos, Pattern mat, double size) throws MaxChangedBlocksException {
        BaseBlock air2 = new BaseBlock(0, 0);
        double startY = this.fullHeight ? (double)editSession.getWorld().getMaxY() : (double)pos.getBlockY() + size;
        for (double x2 = (double)pos.getBlockX() + size; x2 > (double)pos.getBlockX() - size; x2 -= 1.0) {
            for (double z2 = (double)pos.getBlockZ() + size; z2 > (double)pos.getBlockZ() - size; z2 -= 1.0) {
                Vector pt2;
                double y2;
                ArrayList<BaseBlock> blockTypes = new ArrayList<BaseBlock>();
                for (y2 = startY; y2 > (double)pos.getBlockY() - size; y2 -= 1.0) {
                    pt2 = new Vector(x2, y2, z2);
                    BaseBlock block = editSession.getBlock(pt2);
                    if (block.isAir()) continue;
                    blockTypes.add(block);
                    editSession.setBlock(pt2, air2);
                }
                pt2 = new Vector(x2, y2, z2);
                Collections.reverse(blockTypes);
                int i2 = 0;
                while (i2 < blockTypes.size()) {
                    if (editSession.getBlock(pt2).getType() == 0) {
                        editSession.setBlock(pt2, (BaseBlock)blockTypes.get(i2++));
                    }
                    pt2 = pt2.add(0, 1, 0);
                }
            }
        }
    }
}

