/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.tools.brushes;

import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.HeightMap;
import wecui.vendor.com.sk89q.worldedit.MaxChangedBlocksException;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.filtering.GaussianKernel;
import wecui.vendor.com.sk89q.worldedit.filtering.HeightMapFilter;
import wecui.vendor.com.sk89q.worldedit.patterns.Pattern;
import wecui.vendor.com.sk89q.worldedit.regions.CuboidRegion;
import wecui.vendor.com.sk89q.worldedit.tools.brushes.Brush;

public class SmoothBrush
implements Brush {
    private int iterations;
    private boolean naturalOnly;

    public SmoothBrush(int iterations) {
        this(iterations, false);
    }

    public SmoothBrush(int iterations, boolean naturalOnly) {
        this.iterations = iterations;
        this.naturalOnly = naturalOnly;
    }

    @Override
    public void build(EditSession editSession, Vector pos, Pattern mat, double size) throws MaxChangedBlocksException {
        double rad = size;
        WorldVector min = new WorldVector(editSession.getWorld(), pos.subtract(rad, rad, rad));
        Vector max = pos.add(rad, rad + 10.0, rad);
        CuboidRegion region = new CuboidRegion(editSession.getWorld(), min, max);
        HeightMap heightMap = new HeightMap(editSession, region, this.naturalOnly);
        HeightMapFilter filter = new HeightMapFilter(new GaussianKernel(5, 1.0));
        heightMap.applyFilter(filter, this.iterations);
    }
}

