/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.util;

import com.sk89q.worldedit.util.TreeGenerator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.MaxChangedBlocksException;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;

public class TreeGenerator {
    private static Random rand = new Random();
    private TreeType type;

    @Deprecated
    public TreeGenerator(TreeType type) {
        this.type = type;
    }

    public boolean generate(EditSession editSession, Vector pos) throws MaxChangedBlocksException {
        return this.type.generate(editSession, pos);
    }

    private static void makePineTree(EditSession editSession, Vector basePos) throws MaxChangedBlocksException {
        int i2;
        int trunkHeight = (int)Math.floor(Math.random() * 2.0) + 3;
        int height = (int)Math.floor(Math.random() * 5.0) + 8;
        BaseBlock logBlock = new BaseBlock(17);
        BaseBlock leavesBlock = new BaseBlock(18);
        for (i2 = 0; i2 < trunkHeight; ++i2) {
            if (editSession.setBlockIfAir(basePos.add(0, i2, 0), logBlock)) continue;
            return;
        }
        basePos = basePos.add(0, trunkHeight, 0);
        for (i2 = 0; i2 < height; ++i2) {
            int j2;
            editSession.setBlockIfAir(basePos.add(0, i2, 0), logBlock);
            double chance = i2 == 0 || i2 == height - 1 ? 0.6 : 1.0;
            editSession.setChanceBlockIfAir(basePos.add(-1, i2, 0), leavesBlock, chance);
            editSession.setChanceBlockIfAir(basePos.add(1, i2, 0), leavesBlock, chance);
            editSession.setChanceBlockIfAir(basePos.add(0, i2, -1), leavesBlock, chance);
            editSession.setChanceBlockIfAir(basePos.add(0, i2, 1), leavesBlock, chance);
            editSession.setChanceBlockIfAir(basePos.add(1, i2, 1), leavesBlock, chance);
            editSession.setChanceBlockIfAir(basePos.add(-1, i2, 1), leavesBlock, chance);
            editSession.setChanceBlockIfAir(basePos.add(1, i2, -1), leavesBlock, chance);
            editSession.setChanceBlockIfAir(basePos.add(-1, i2, -1), leavesBlock, chance);
            if (i2 == 0 || i2 == height - 1) continue;
            for (j2 = -2; j2 <= 2; ++j2) {
                editSession.setChanceBlockIfAir(basePos.add(-2, i2, j2), leavesBlock, 0.6);
            }
            for (j2 = -2; j2 <= 2; ++j2) {
                editSession.setChanceBlockIfAir(basePos.add(2, i2, j2), leavesBlock, 0.6);
            }
            for (j2 = -2; j2 <= 2; ++j2) {
                editSession.setChanceBlockIfAir(basePos.add(j2, i2, -2), leavesBlock, 0.6);
            }
            for (j2 = -2; j2 <= 2; ++j2) {
                editSession.setChanceBlockIfAir(basePos.add(j2, i2, 2), leavesBlock, 0.6);
            }
        }
        editSession.setBlockIfAir(basePos.add(0, height, 0), leavesBlock);
    }

    public static TreeType lookup(String type) {
        return TreeType.lookup(type);
    }

    public static enum TreeType {
        TREE("Regular tree", "tree", "regular"),
        BIG_TREE("Big tree", "big", "bigtree"),
        REDWOOD("Redwood", "redwood", "sequoia", "sequoioideae"),
        TALL_REDWOOD("Tall redwood", "tallredwood", "tallsequoia", "tallsequoioideae"),
        BIRCH("Birch", "birch", "white", "whitebark"),
        PINE("Pine", new String[]{"pine"}){

            @Override
            public boolean generate(EditSession editSession, Vector pos) throws MaxChangedBlocksException {
                TreeGenerator.makePineTree(editSession, pos);
                return true;
            }
        }
        ,
        RANDOM_REDWOOD("Random redwood", new String[]{"randredwood", "randomredwood", "anyredwood"}){

            @Override
            public boolean generate(EditSession editSession, Vector pos) throws MaxChangedBlocksException {
                TreeType[] choices = new TreeType[]{REDWOOD, TALL_REDWOOD};
                return choices[rand.nextInt(choices.length)].generate(editSession, pos);
            }
        }
        ,
        JUNGLE("Jungle", "jungle"),
        SHORT_JUNGLE("Short jungle", "shortjungle", "smalljungle"),
        JUNGLE_BUSH("Jungle bush", "junglebush", "jungleshrub"),
        RED_MUSHROOM("Red Mushroom", "redmushroom", "redgiantmushroom"),
        BROWN_MUSHROOM("Brown Mushroom", "brownmushroom", "browngiantmushroom"),
        SWAMP("Swamp", "swamp", "swamptree"),
        RANDOM("Random", new String[]{"rand", "random"}){

            @Override
            public boolean generate(EditSession editSession, Vector pos) throws MaxChangedBlocksException {
                TreeType[] choices = new TreeType[]{TREE, BIG_TREE, BIRCH, REDWOOD, TALL_REDWOOD, PINE};
                return choices[rand.nextInt(choices.length)].generate(editSession, pos);
            }
        };

        private static final Map<String, TreeGenerator.TreeType> lookup;
        private final String name;
        private final String[] lookupKeys;

        private TreeType(String name, String ... lookupKeys) {
            this.name = name;
            this.lookupKeys = lookupKeys;
        }

        public boolean generate(EditSession editSession, Vector pos) throws MaxChangedBlocksException {
            return editSession.getWorld().generateTree(this, editSession, pos);
        }

        public String getName() {
            return this.name;
        }

        public static TreeType lookup(String name) {
            return (TreeType)lookup.get(name.toLowerCase());
        }

        static {
            lookup = new HashMap<String, TreeGenerator.TreeType>();
            for (TreeType type : EnumSet.allOf(TreeType.class)) {
                for (String key : type.lookupKeys) {
                    lookup.put(key, (TreeGenerator.TreeType)type);
                }
            }
        }
    }
}

