/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.org.joor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import wecui.exception.ReflectException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflect {
    private final Object object;
    private final boolean isClass;

    public static Reflect on(String name) throws ReflectException {
        return Reflect.on(Reflect.forName(name));
    }

    public static Reflect on(Class<?> clazz) {
        return new Reflect(clazz);
    }

    public static Reflect on(Object object) {
        return new Reflect(object);
    }

    private Reflect(Class<?> type) {
        this.object = type;
        this.isClass = true;
    }

    private Reflect(Object object) {
        this.object = object;
        this.isClass = false;
    }

    public <T> T get() {
        return (T)this.object;
    }

    public Reflect set(String name, Object value) throws ReflectException {
        try {
            Field field = this.type().getField(name);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(this.object, Reflect.unwrap(value));
            return this;
        }
        catch (Exception e2) {
            throw new ReflectException(e2);
        }
    }

    public Object get(String name) throws ReflectException {
        return this.field(name).get();
    }

    public Reflect field(String name) throws ReflectException {
        try {
            Field field = this.type().getField(name);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return Reflect.on(field.get(this.object));
        }
        catch (Exception e2) {
            throw new ReflectException(e2);
        }
    }

    public Map<String, Reflect> fields() {
        LinkedHashMap<String, Reflect> result = new LinkedHashMap<String, Reflect>();
        for (Field field : this.type().getFields()) {
            if (!(!this.isClass ^ Modifier.isStatic(field.getModifiers()))) continue;
            String name = field.getName();
            result.put(name, this.field(name));
        }
        return result;
    }

    public Reflect call(String name) throws ReflectException {
        return this.call(name, new Object[0]);
    }

    public Reflect call(String name, Object ... args) throws ReflectException {
        Class<?>[] types = Reflect.types(args);
        try {
            Method method = this.type().getMethod(name, types);
            return Reflect.on(method, this.object, args);
        }
        catch (NoSuchMethodException e2) {
            for (Method method : this.type().getMethods()) {
                if (!method.getName().equals(name) || !this.match(method.getParameterTypes(), types)) continue;
                return Reflect.on(method, this.object, args);
            }
            throw new ReflectException(e2);
        }
    }

    public Reflect create() throws ReflectException {
        return this.create(new Object[0]);
    }

    public Reflect create(Object ... args) throws ReflectException {
        Class<?>[] types = Reflect.types(args);
        try {
            Constructor<?> constructor = this.type().getConstructor(types);
            return Reflect.on(constructor, args);
        }
        catch (NoSuchMethodException e2) {
            for (Constructor<?> constructor : this.type().getConstructors()) {
                if (!this.match(constructor.getParameterTypes(), types)) continue;
                return Reflect.on(constructor, args);
            }
            throw new ReflectException(e2);
        }
    }

    private boolean match(Class<?>[] declaredTypes, Class<?>[] actualTypes) {
        if (declaredTypes.length == actualTypes.length) {
            for (int i2 = 0; i2 < actualTypes.length; ++i2) {
                if (Reflect.wrapper(declaredTypes[i2]).isAssignableFrom(Reflect.wrapper(actualTypes[i2]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Reflect) {
            return this.object.equals(((Reflect)obj).get());
        }
        return false;
    }

    public String toString() {
        return this.object.toString();
    }

    private static Reflect on(Constructor<?> constructor, Object ... args) throws ReflectException {
        try {
            return Reflect.on(constructor.newInstance(args));
        }
        catch (Exception e2) {
            throw new ReflectException(e2);
        }
    }

    private static Reflect on(Method method, Object object, Object ... args) throws ReflectException {
        try {
            if (method.getReturnType() == Void.TYPE) {
                method.invoke(object, args);
                return Reflect.on(object);
            }
            return Reflect.on(method.invoke(object, args));
        }
        catch (Exception e2) {
            throw new ReflectException(e2);
        }
    }

    private static Object unwrap(Object object) {
        if (object instanceof Reflect) {
            return ((Reflect)object).get();
        }
        return object;
    }

    private static Class<?>[] types(Object ... values) {
        if (values == null) {
            return new Class[0];
        }
        Class[] result = new Class[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            result[i2] = values[i2].getClass();
        }
        return result;
    }

    private static Class<?> forName(String name) throws ReflectException {
        try {
            return Class.forName(name);
        }
        catch (Exception e2) {
            throw new ReflectException(e2);
        }
    }

    private Class<?> type() {
        if (this.isClass) {
            return (Class)this.object;
        }
        return this.object.getClass();
    }

    private static Class<?> wrapper(Class<?> type) {
        if (Boolean.TYPE == type) {
            return Boolean.class;
        }
        if (Integer.TYPE == type) {
            return Integer.class;
        }
        if (Long.TYPE == type) {
            return Long.class;
        }
        if (Short.TYPE == type) {
            return Short.class;
        }
        if (Byte.TYPE == type) {
            return Byte.class;
        }
        if (Double.TYPE == type) {
            return Double.class;
        }
        if (Float.TYPE == type) {
            return Float.class;
        }
        if (Character.TYPE == type) {
            return Character.class;
        }
        return type;
    }
}

