/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.org.yaml.snakeyaml;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import wecui.vendor.org.yaml.snakeyaml.DumperOptions;
import wecui.vendor.org.yaml.snakeyaml.LoaderOptions;
import wecui.vendor.org.yaml.snakeyaml.TypeDescription;
import wecui.vendor.org.yaml.snakeyaml.Yaml;
import wecui.vendor.org.yaml.snakeyaml.constructor.Constructor;
import wecui.vendor.org.yaml.snakeyaml.introspector.BeanAccess;
import wecui.vendor.org.yaml.snakeyaml.reader.UnicodeReader;
import wecui.vendor.org.yaml.snakeyaml.representer.Representer;
import wecui.vendor.org.yaml.snakeyaml.resolver.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanLoader<T> {
    private Yaml loader;

    public JavaBeanLoader(TypeDescription typeDescription) {
        this(typeDescription, BeanAccess.DEFAULT);
    }

    public JavaBeanLoader(TypeDescription typeDescription, BeanAccess beanAccess) {
        this(new LoaderOptions(typeDescription), beanAccess);
    }

    public JavaBeanLoader(LoaderOptions options, BeanAccess beanAccess) {
        if (options == null) {
            throw new NullPointerException("LoaderOptions must be provided.");
        }
        if (options.getRootTypeDescription() == null) {
            throw new NullPointerException("TypeDescription must be provided.");
        }
        Constructor constructor = new Constructor(options.getRootTypeDescription());
        this.loader = new Yaml(constructor, options, new Representer(), new DumperOptions(), new Resolver());
        this.loader.setBeanAccess(beanAccess);
    }

    public <S extends T> JavaBeanLoader(Class<S> clazz, BeanAccess beanAccess) {
        this(new TypeDescription(clazz), beanAccess);
    }

    public <S extends T> JavaBeanLoader(Class<S> clazz) {
        this(clazz, BeanAccess.DEFAULT);
    }

    public T load(String yaml) {
        return (T)this.loader.load(new StringReader(yaml));
    }

    public T load(InputStream io2) {
        return (T)this.loader.load(new UnicodeReader(io2));
    }

    public T load(Reader io2) {
        return (T)this.loader.load(io2);
    }
}

