/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.org.yaml.snakeyaml.reader;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wecui.vendor.org.yaml.snakeyaml.error.Mark;
import wecui.vendor.org.yaml.snakeyaml.error.YAMLException;
import wecui.vendor.org.yaml.snakeyaml.reader.ReaderException;
import wecui.vendor.org.yaml.snakeyaml.reader.UnicodeReader;
import wecui.vendor.org.yaml.snakeyaml.scanner.Constant;

public class StreamReader {
    static final Pattern NON_PRINTABLE = Pattern.compile("[^\t\n\r -~\u0085\u00a0-\ud7ff\ue000-\ufffc]");
    private String name;
    private final Reader stream;
    private int pointer = 0;
    private boolean eof = true;
    private String buffer;
    private int index = 0;
    private int line = 0;
    private int column = 0;
    private char[] data;

    public StreamReader(String stream) {
        this.name = "<string>";
        this.buffer = "";
        this.checkPrintable(stream);
        this.buffer = stream + "\u0000";
        this.stream = null;
        this.eof = true;
        this.data = null;
    }

    public StreamReader(Reader reader) {
        this.name = "<reader>";
        this.buffer = "";
        this.stream = reader;
        this.eof = false;
        this.data = new char[1024];
        this.update();
    }

    void checkPrintable(CharSequence data) {
        Matcher em2 = NON_PRINTABLE.matcher(data);
        if (em2.find()) {
            int position = this.index + this.buffer.length() - this.pointer + em2.start();
            throw new ReaderException(this.name, position, em2.group().charAt(0), "special characters are not allowed");
        }
    }

    void checkPrintable(char[] chars, int begin, int end) {
        for (int i2 = begin; i2 < end; ++i2) {
            char c2 = chars[i2];
            if (c2 >= ' ' && c2 <= '~' || c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == '\u0085' || c2 >= '\u00a0' && c2 <= '\ud7ff' || c2 >= '\ue000' && c2 <= '\ufffc') continue;
            int position = this.index + this.buffer.length() - this.pointer + i2;
            throw new ReaderException(this.name, position, c2, "special characters are not allowed");
        }
    }

    public Mark getMark() {
        return new Mark(this.name, this.index, this.line, this.column, this.buffer, this.pointer);
    }

    public void forward() {
        this.forward(1);
    }

    public void forward(int length) {
        if (this.pointer + length + 1 >= this.buffer.length()) {
            this.update();
        }
        char ch2 = '\u0000';
        for (int i2 = 0; i2 < length; ++i2) {
            ch2 = this.buffer.charAt(this.pointer);
            ++this.pointer;
            ++this.index;
            if (Constant.LINEBR.has(ch2) || ch2 == '\r' && this.buffer.charAt(this.pointer) != '\n') {
                ++this.line;
                this.column = 0;
                continue;
            }
            if (ch2 == '\ufeff') continue;
            ++this.column;
        }
    }

    public char peek() {
        return this.buffer.charAt(this.pointer);
    }

    public char peek(int index) {
        if (this.pointer + index + 1 > this.buffer.length()) {
            this.update();
        }
        return this.buffer.charAt(this.pointer + index);
    }

    public String prefix(int length) {
        if (this.pointer + length >= this.buffer.length()) {
            this.update();
        }
        if (this.pointer + length > this.buffer.length()) {
            return this.buffer.substring(this.pointer);
        }
        return this.buffer.substring(this.pointer, this.pointer + length);
    }

    public String prefixForward(int length) {
        String prefix = this.prefix(length);
        this.pointer += length;
        this.index += length;
        this.column += length;
        return prefix;
    }

    private void update() {
        if (!this.eof) {
            this.buffer = this.buffer.substring(this.pointer);
            this.pointer = 0;
            try {
                int converted = this.stream.read(this.data);
                if (converted > 0) {
                    this.checkPrintable(this.data, 0, converted);
                    this.buffer = new StringBuilder(this.buffer.length() + converted).append(this.buffer).append(this.data, 0, converted).toString();
                } else {
                    this.eof = true;
                    this.buffer = this.buffer + "\u0000";
                }
            }
            catch (IOException ioe) {
                throw new YAMLException(ioe);
            }
        }
    }

    public int getColumn() {
        return this.column;
    }

    public Charset getEncoding() {
        return Charset.forName(((UnicodeReader)this.stream).getEncoding());
    }

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }
}

