/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import java.util.BitSet;

class BlockTracker {
    private static final BlockTracker INSTANCE = new BlockTracker();
    private BitSet allocatedBlocks = new BitSet(4096);

    private BlockTracker() {
        this.allocatedBlocks.set(0, 4096);
        for (int i = 0; i < apa.r.length; ++i) {
            if (apa.r[i] == null) continue;
            this.allocatedBlocks.clear(i);
        }
    }

    public static int nextBlockId() {
        return BlockTracker.instance().getNextBlockId();
    }

    private int getNextBlockId() {
        int idx = this.allocatedBlocks.nextSetBit(0);
        this.allocatedBlocks.clear(idx);
        return idx;
    }

    private static BlockTracker instance() {
        return INSTANCE;
    }

    public static void reserveBlockId(int id) {
        BlockTracker.instance().doReserveId(id);
    }

    private void doReserveId(int id) {
        this.allocatedBlocks.clear(id);
    }
}

