/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.event.ASMEventHandler;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.IEventListener;
import net.minecraftforge.event.ListenerList;

public class EventBus {
    private static int maxID = 0;
    private ConcurrentHashMap<Object, ArrayList<IEventListener>> listeners = new ConcurrentHashMap();
    private final int busID = maxID++;

    public EventBus() {
        ListenerList.resize(this.busID + 1);
    }

    public void register(Object target) {
        Set supers = TypeToken.of(target.getClass()).getTypes().rawTypes();
        block2: for (Method method : target.getClass().getMethods()) {
            for (Class cls : supers) {
                try {
                    Method real = cls.getDeclaredMethod(method.getName(), method.getParameterTypes());
                    if (!real.isAnnotationPresent(ForgeSubscribe.class)) continue;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != 1) {
                        throw new IllegalArgumentException("Method " + method + " has @ForgeSubscribe annotation, but requires " + parameterTypes.length + " arguments.  Event handler methods must require a single argument.");
                    }
                    Class<?> eventType = parameterTypes[0];
                    if (!Event.class.isAssignableFrom(eventType)) {
                        throw new IllegalArgumentException("Method " + method + " has @ForgeSubscribe annotation, but takes a argument that is not a Event " + eventType);
                    }
                    this.register(eventType, target, method);
                    continue block2;
                }
                catch (NoSuchMethodException e) {
                }
            }
        }
    }

    private void register(Class<?> eventType, Object target, Method method) {
        try {
            Constructor<?> ctr = eventType.getConstructor(new Class[0]);
            ctr.setAccessible(true);
            Event event = (Event)ctr.newInstance(new Object[0]);
            ASMEventHandler listener = new ASMEventHandler(target, method);
            event.getListenerList().register(this.busID, listener.getPriority(), listener);
            ArrayList<IEventListener> others = this.listeners.get(target);
            if (others == null) {
                others = new ArrayList();
                this.listeners.put(target, others);
            }
            others.add(listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unregister(Object object) {
        ArrayList<IEventListener> list = this.listeners.remove(object);
        for (IEventListener listener : list) {
            ListenerList.unregiterAll(this.busID, listener);
        }
    }

    public boolean post(Event event) {
        IEventListener[] listeners;
        for (IEventListener listener : listeners = event.getListenerList().getListeners(this.busID)) {
            listener.invoke(event);
        }
        return event.isCancelable() ? event.isCanceled() : false;
    }
}

