/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.HashMap;
import net.buycraft.ChatManager;
import net.buycraft.PlayerListener;
import net.buycraft.api.Api;
import net.buycraft.commands.BuyCommand;
import net.buycraft.commands.BuycraftCommand;
import net.buycraft.commands.EnableChatCommand;
import net.buycraft.packages.PackageChecker;
import net.buycraft.packages.PackageManager;
import net.buycraft.util.Chat;
import net.buycraft.util.Language;
import net.buycraft.util.Settings;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitInterface
extends JavaPlugin {
    private static BukkitInterface instance;
    private String version;
    private Settings settings;
    private Language language;
    private Api api;
    private Integer serverID;
    private String serverCurrency;
    private PackageManager packageManager;
    private PackageChecker packageChecker;
    private ChatManager chatManager;
    private int packagesCheckerThreadId;
    private Boolean started;

    public BukkitInterface() {
        instance = this;
    }

    public void onEnable() {
        this.checkDirectory();
        this.moveFileFromJar("README.txt", "plugins/Buycraft/README.txt", true);
        this.version = this.getDescription().getVersion();
        this.settings = new Settings();
        this.language = new Language();
        this.api = new Api();
        this.packageManager = new PackageManager();
        this.packageChecker = new PackageChecker();
        this.chatManager = new ChatManager();
        if (this.api.infoAction().booleanValue()) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
            this.packageManager.loadPackages();
            this.packagesCheckerThreadId = this.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, (Runnable)this.packageChecker, 6000L, 6000L);
            this.started = true;
            this.getLogger().info("Plugin has been successfully enabled.");
        } else {
            this.started = false;
        }
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTask(this.packagesCheckerThreadId);
        this.getLogger().info("Plugin has been disabled.");
    }

    public boolean onCommand(CommandSender commandSender, Command command, String label, String[] args) {
        HashMap<String, Integer> commandList = new HashMap<String, Integer>();
        commandList.put("buy", 0);
        commandList.put("donate", 1);
        commandList.put("purchase", 2);
        commandList.put("store", 3);
        commandList.put("shop", 4);
        commandList.put("ec", 5);
        commandList.put("buycraft", 6);
        Boolean status = false;
        switch ((Integer)commandList.get(command.getLabel().toLowerCase())) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                status = BuyCommand.process(commandSender, args);
                break;
            }
            case 5: {
                status = EnableChatCommand.process(commandSender, args);
                break;
            }
            case 6: {
                status = BuycraftCommand.process(commandSender, args);
            }
        }
        return status;
    }

    private void checkDirectory() {
        File directory = new File("plugins/Buycraft");
        if (!directory.exists()) {
            directory.mkdir();
        }
    }

    public void moveFileFromJar(String jarFileName, String targetLocation, Boolean overwrite) {
        try {
            File targetFile = new File(targetLocation);
            if (overwrite.booleanValue() || !targetFile.exists() || targetFile.length() == 0L) {
                int c;
                InputStream inFile = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(jarFileName);
                FileWriter outFile = new FileWriter(targetFile);
                while ((c = inFile.read()) != -1) {
                    outFile.write(c);
                }
                inFile.close();
                outFile.close();
            }
        }
        catch (NullPointerException e) {
            this.getLogger().info("Failed to create " + jarFileName + ".");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Boolean requireStarted(CommandSender commandSender) {
        if (!this.started.booleanValue()) {
            commandSender.sendMessage(Chat.header());
            commandSender.sendMessage(Chat.seperator());
            commandSender.sendMessage(String.valueOf(Chat.seperator()) + ChatColor.RED + BukkitInterface.getInstance().getLanguage().getString("notStarted"));
            commandSender.sendMessage(Chat.seperator());
            commandSender.sendMessage(Chat.footer());
            return false;
        }
        return true;
    }

    public void disablePlugin() {
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }

    public static BukkitInterface getInstance() {
        return instance;
    }

    public Api getApi() {
        return this.api;
    }

    public void setServerID(Integer value) {
        this.serverID = value;
    }

    public void setServerCurrency(String value) {
        this.serverCurrency = value;
    }

    public Integer getServerID() {
        return this.serverID;
    }

    public PackageChecker getPackageChecker() {
        return this.packageChecker;
    }

    public PackageManager getPackageManager() {
        return this.packageManager;
    }

    public String getServerCurrency() {
        return this.serverCurrency;
    }

    public String getVersion() {
        return this.version;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Language getLanguage() {
        return this.language;
    }

    public File getJarFile() {
        return this.getFile();
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }
}

