/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.packages;

import java.util.ArrayList;
import java.util.List;
import net.buycraft.BukkitInterface;
import net.buycraft.packages.PackageModel;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageManager {
    private List<PackageModel> packagesForSale = new ArrayList<PackageModel>();

    public void loadPackages() {
        this.packagesForSale.clear();
        try {
            JSONObject apiResponse = BukkitInterface.getInstance().getApi().packagesAction();
            if (apiResponse != null && !apiResponse.isNull("payload")) {
                JSONArray packages = apiResponse.getJSONArray("payload");
                int i = 0;
                while (i < packages.length()) {
                    if (!packages.isNull(i)) {
                        JSONObject row = packages.getJSONObject(i);
                        this.addPackage(row.getInt("id"), row.get("name").toString(), row.get("price").toString());
                    }
                    ++i;
                }
                BukkitInterface.getInstance().getLogger().info("Loaded " + packages.length() + " package(s) into the cache.");
            } else {
                BukkitInterface.getInstance().getLogger().severe("Failed to load packages due to null payload.");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            BukkitInterface.getInstance().getLogger().severe("Failed to load packages due to JSON parse error.");
        }
    }

    private void addPackage(int id, String name, String price) {
        this.packagesForSale.add(new PackageModel(id, name, price));
    }

    public List<PackageModel> getPackagesForSale() {
        return this.packagesForSale;
    }

    public PackageModel getPackageById(int packageId) {
        for (PackageModel packageModel : this.packagesForSale) {
            if (packageModel.getId() != packageId) continue;
            return packageModel;
        }
        return null;
    }
}

