/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Language {
    private final String LOCATION = "plugins/Buycraft/language.conf";
    private File file = new File("plugins/Buycraft/language.conf");
    private HashMap<String, String> defaultProperties = new HashMap();
    private Properties properties = new Properties();

    public Language() {
        this.load();
        this.assignDefault();
    }

    private void load() {
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            this.properties.load(new FileInputStream("plugins/Buycraft/language.conf"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void assignDefault() {
        Boolean toSave = false;
        this.defaultProperties.put("mainCommand", "/buy");
        this.defaultProperties.put("chatEnabled", "Your chat is now enabled");
        this.defaultProperties.put("chatAlreadyEnabled", "Your chat is already enabled");
        this.defaultProperties.put("viewAvailablePackagesHelp", "View available packages for sale");
        this.defaultProperties.put("navigateThroughPackagesHelp", "Navigate through package pages");
        this.defaultProperties.put("purchaseSpecificPackageHelp", "Purchase a specific package");
        this.defaultProperties.put("purchasedPackageExpired", "Your purchased package has now expired");
        this.defaultProperties.put("purchasedPackageClaimed", "Your purchased package has been credited to your account");
        this.defaultProperties.put("pleaseVisit", "Please click the link below to continue with the purchase");
        this.defaultProperties.put("turnChatBackOn", "Type /ec to turn your chat back on");
        this.defaultProperties.put("packageNotFound", "Package not found");
        this.defaultProperties.put("noPackagesForSale", "We currently do not have any packages for sale");
        this.defaultProperties.put("toPurchase", "To purchase a package, please type");
        this.defaultProperties.put("howToNavigate", "Browse through our packages by using");
        this.defaultProperties.put("packageId", "ID");
        this.defaultProperties.put("packageName", "Name");
        this.defaultProperties.put("packagePrice", "Price");
        this.defaultProperties.put("pageNotFound", "Page not found");
        this.defaultProperties.put("packageCacheReloaded", "Package cache successfully reloaded");
        this.defaultProperties.put("forceCheckPerformed", "Force check successfully performed");
        this.defaultProperties.put("notStarted", "Buycraft incorrectly setup, please read the README.txt file");
        this.defaultProperties.put("secretKeySet", "Secret key successfully updated. Reloading server...");
        this.defaultProperties.put("enterValidSecret", "Please enter a valid API secret");
        this.defaultProperties.put("permissionDenied", "You do not have permission to execute that command");
        this.defaultProperties.put("secretKeyInfo", "Specify your secret key");
        this.defaultProperties.put("reloadInfo", "Reload the package cache");
        this.defaultProperties.put("forcecheckInfo", "Manually check for payments");
        for (Map.Entry<String, String> entry : this.defaultProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (this.properties.containsKey(key)) continue;
            this.properties.setProperty(key, value);
            toSave = true;
        }
        if (toSave.booleanValue()) {
            try {
                this.properties.store(new FileOutputStream("plugins/Buycraft/language.conf"), "Buycraft Plugin (English language file)");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getString(String key) {
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        throw new RuntimeException("Language key '" + key + "' not found in the language.conf file.");
    }
}

