/*
 * Decompiled with CFR 0.152.
 */
package net.buycraft.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Settings {
    private final String LOCATION = "plugins/Buycraft/settings.conf";
    private File file = new File("plugins/Buycraft/settings.conf");
    private HashMap<String, String> defaultProperties = new HashMap();
    private Properties properties = new Properties();

    public Settings() {
        this.load();
        this.assignDefault();
    }

    private void load() {
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            this.properties.load(new FileInputStream("plugins/Buycraft/settings.conf"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void assignDefault() {
        Boolean toSave = false;
        this.defaultProperties.put("secret", "");
        this.defaultProperties.put("autoUpdate", "true");
        this.defaultProperties.put("https", "false");
        this.defaultProperties.put("disableBuyCommand", "false");
        for (Map.Entry<String, String> entry : this.defaultProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (this.properties.containsKey(key)) continue;
            this.properties.setProperty(key, value);
            toSave = true;
        }
        if (toSave.booleanValue()) {
            this.saveSettings();
        }
    }

    private void saveSettings() {
        try {
            this.properties.store(new FileOutputStream("plugins/Buycraft/settings.conf"), "Buycraft Plugin");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean getBoolean(String key) {
        if (this.properties.containsKey(key)) {
            return Boolean.valueOf(this.getString(key));
        }
        throw new RuntimeException("Settings key '" + key + "' not found in the settings.conf file.");
    }

    public String getString(String key) {
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        throw new RuntimeException("Settings key '" + key + "' not found in the settings.conf file.");
    }

    public void setString(String key, String value) {
        this.properties.setProperty("secret", value);
        this.saveSettings();
    }
}

