/*
 * Decompiled with CFR 0.152.
 */
package ic2.api;

import ic2.api.BaseSeed;
import ic2.api.TECrop;
import java.util.HashMap;

public abstract class CropCard {
    private static final CropCard[] cropCardList = new CropCard[256];
    public static TECrop nameReference;
    private static HashMap baseseeds;

    public abstract String name();

    public String discoveredBy() {
        return "Alblaka";
    }

    public String desc(int i) {
        String[] att = this.attributes();
        if (att == null || att.length == 0) {
            return "";
        }
        if (i == 0) {
            String s = att[0];
            if (att.length >= 2) {
                s = s + ", " + att[1];
                if (att.length >= 3) {
                    s = s + ",";
                }
            }
            return s;
        }
        if (att.length < 3) {
            return "";
        }
        String s = att[2];
        if (att.length >= 4) {
            s = s + ", " + att[3];
        }
        return s;
    }

    public abstract int tier();

    public abstract int stat(int var1);

    public abstract String[] attributes();

    public abstract int getSpriteIndex(TECrop var1);

    public String getTextureFile() {
        return "/ic2/sprites/crops_0.png";
    }

    public int growthDuration(TECrop crop) {
        return this.tier() * 200;
    }

    public abstract boolean canGrow(TECrop var1);

    public int weightInfluences(TECrop crop, float humidity, float nutrients, float air) {
        return (int)(humidity + nutrients + air);
    }

    public boolean canCross(TECrop crop) {
        return crop.size >= 3;
    }

    public boolean rightclick(TECrop crop, yw player) {
        return crop.harvest(true);
    }

    public abstract boolean canBeHarvested(TECrop var1);

    public float dropGainChance() {
        float base = 1.0f;
        for (int i = 0; i < this.tier(); ++i) {
            base = (float)((double)base * 0.95);
        }
        return base;
    }

    public abstract aan getGain(TECrop var1);

    public byte getSizeAfterHarvest(TECrop crop) {
        return 1;
    }

    public boolean leftclick(TECrop crop, yw player) {
        return crop.pick(true);
    }

    public float dropSeedChance(TECrop crop) {
        if (crop.size == 1) {
            return 0.0f;
        }
        float base = 0.5f;
        if (crop.size == 2) {
            base /= 2.0f;
        }
        for (int i = 0; i < this.tier(); ++i) {
            base = (float)((double)base * 0.8);
        }
        return base;
    }

    public aan getSeeds(TECrop crop) {
        return crop.generateSeeds(crop.id, crop.statGrowth, crop.statGain, crop.statResistance, crop.scanLevel);
    }

    public void onNeighbourChange(TECrop crop) {
    }

    public boolean emitRedstone(TECrop crop) {
        return false;
    }

    public void onBlockDestroyed(TECrop crop) {
    }

    public int getEmittedLight(TECrop crop) {
        return 0;
    }

    public boolean onEntityCollision(TECrop crop, nn entity) {
        if (entity instanceof acq) {
            return ((acq)entity).s < 0.1 || ((acq)entity).W();
        }
        return false;
    }

    public void tick(TECrop crop) {
    }

    public boolean isWeed(TECrop crop) {
        return crop.size >= 2 && (crop.id == 0 || crop.statGrowth >= 24);
    }

    public final int getId() {
        for (int i = 0; i < cropCardList.length; ++i) {
            if (this != cropCardList[i]) continue;
            return i;
        }
        return -1;
    }

    public static int cropCardListLength() {
        return cropCardList.length;
    }

    public static final CropCard getCrop(int id) {
        if (id < 0 || id >= cropCardList.length) {
            return cropCardList[0];
        }
        if (cropCardList[id] == null) {
            System.out.println("[IndustrialCraft] Something tried to access non-existant cropID #" + id + "!!!");
            return cropCardList[0];
        }
        return cropCardList[id];
    }

    public static final boolean idExists(int id) {
        return id >= 0 && id < cropCardList.length && cropCardList[id] != null;
    }

    public static final short registerCrop(CropCard crop) {
        for (short x = 0; x < cropCardList.length; x = (short)((short)(x + 1))) {
            if (cropCardList[x] != null) continue;
            CropCard.cropCardList[x] = crop;
            nameReference.addLocal("item.cropSeed" + x + ".name", crop.name() + " Seeds");
            return x;
        }
        return -1;
    }

    public static final boolean registerCrop(CropCard crop, int i) {
        if (i < 0 || i >= cropCardList.length) {
            return false;
        }
        if (cropCardList[i] == null) {
            CropCard.cropCardList[i] = crop;
            nameReference.addLocal("item.cropSeed" + i + ".name", crop.name() + " Seeds");
            return true;
        }
        System.out.println("[IndustrialCraft] Cannot add crop:" + crop.name() + " on ID #" + i + ", slot already occupied by crop:" + cropCardList[i].name());
        return false;
    }

    public static boolean registerBaseSeed(aan stack, int id, int size, int growth, int gain, int resistance) {
        for (aan key : baseseeds.keySet()) {
            if (key.c != stack.c || key.i() != stack.i()) continue;
            return false;
        }
        baseseeds.put(stack, new BaseSeed(id, size, growth, gain, resistance, stack.a));
        return true;
    }

    public static BaseSeed getBaseSeed(aan stack) {
        if (stack == null) {
            return null;
        }
        for (aan key : baseseeds.keySet()) {
            if (key.c != stack.c || key.i() != -1 && key.i() != stack.i()) continue;
            return (BaseSeed)baseseeds.get(key);
        }
        return null;
    }

    static {
        baseseeds = new HashMap();
    }
}

