/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.IElectricItem;
import ic2.api.IEnergySource;
import ic2.common.ElectricItem;
import ic2.common.EnergyNet;
import ic2.common.IHasGui;
import ic2.common.PositionSpec;
import ic2.common.TileEntityMachine;
import ic2.platform.AudioManager;
import ic2.platform.AudioSource;
import ic2.platform.Platform;
import java.util.Random;

public abstract class TileEntityBaseGenerator
extends TileEntityMachine
implements IEnergySource,
IHasGui {
    public static Random random = new Random();
    public int fuel = 0;
    public short storage = 0;
    public final short maxStorage;
    public int production;
    public int tier = 1;
    public int ticksSinceLastActiveUpdate;
    public int activityMeter = 0;
    public boolean addedToEnergyNet = false;
    public AudioSource audioSource;

    public TileEntityBaseGenerator(int slots, int production, int maxStorage) {
        super(slots);
        this.production = production;
        this.maxStorage = (short)maxStorage;
        this.ticksSinceLastActiveUpdate = random.nextInt(256);
    }

    @Override
    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        try {
            this.fuel = nbttagcompound.f("fuel");
        }
        catch (Throwable e) {
            this.fuel = nbttagcompound.e("fuel");
        }
        this.storage = nbttagcompound.e("storage");
    }

    @Override
    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("fuel", this.fuel);
        nbttagcompound.a("storage", this.storage);
    }

    public int gaugeStorageScaled(int i) {
        return this.storage * i / this.maxStorage;
    }

    public abstract int gaugeFuelScaled(int var1);

    @Override
    public void n_() {
        super.n_();
        boolean needsInvUpdate = false;
        if (this.needsFuel()) {
            needsInvUpdate = this.gainFuel();
        }
        boolean newActive = this.gainEnergy();
        if (this.storage > this.maxStorage) {
            this.storage = this.maxStorage;
        }
        if (this.storage > 0) {
            int output;
            if (this.inventory[0] != null && yr.e[this.inventory[0].c] instanceof IElectricItem) {
                int used = ElectricItem.charge(this.inventory[0], this.storage, 1, false, false);
                this.storage = (short)(this.storage - used);
                if (used > 0) {
                    needsInvUpdate = true;
                }
            }
            if ((output = Math.min(this.production, this.storage)) > 0) {
                this.storage = (short)(this.storage + (this.sendEnergy(output) - output));
            }
        }
        if (needsInvUpdate) {
            this.j();
        }
        if (!this.delayActiveUpdate()) {
            this.setActive(newActive);
        } else {
            if (this.ticksSinceLastActiveUpdate % 256 == 0) {
                this.setActive(this.activityMeter > 0);
                this.activityMeter = 0;
            }
            this.activityMeter = newActive ? ++this.activityMeter : --this.activityMeter;
            ++this.ticksSinceLastActiveUpdate;
        }
    }

    @Override
    public void onCreated() {
        super.onCreated();
        if (Platform.isSimulating()) {
            EnergyNet.getForWorld(this.i).addTileEntity(this);
            this.addedToEnergyNet = true;
        }
    }

    public void h() {
        if (Platform.isSimulating() && this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.i).removeTileEntity(this);
            this.addedToEnergyNet = false;
        }
        if (Platform.isRendering() && this.audioSource != null) {
            AudioManager.removeSources(this);
            this.audioSource = null;
        }
        super.h();
    }

    public boolean gainEnergy() {
        if (this.isConverting()) {
            this.storage = (short)(this.storage + this.production);
            --this.fuel;
            return true;
        }
        return false;
    }

    public boolean isConverting() {
        return this.fuel > 0 && this.storage + this.production <= this.maxStorage;
    }

    public boolean needsFuel() {
        return this.fuel <= 0 && this.storage + this.production <= this.maxStorage;
    }

    public abstract boolean gainFuel();

    public int sendEnergy(int send) {
        return EnergyNet.getForWorld(this.i).emitEnergyFrom(this, send);
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean emitsEnergyTo(kw receiver, Direction direction) {
        return true;
    }

    @Override
    public int getMaxEnergyOutput() {
        return this.production;
    }

    @Override
    public abstract String c();

    @Override
    public void onGuiClosed(yw entityPlayer) {
    }

    public String getOperationSoundFile() {
        return null;
    }

    public boolean delayActiveUpdate() {
        return false;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null && this.getOperationSoundFile() != null) {
                this.audioSource = AudioManager.createSource(this, PositionSpec.Center, this.getOperationSoundFile(), true, false, AudioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public float getWrenchDropRate() {
        return 0.9f;
    }
}

