/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.IEnergySource;
import ic2.api.IReactor;
import ic2.common.ContainerIC2;
import ic2.common.ContainerNuclearReactor;
import ic2.common.EnergyNet;
import ic2.common.ExplosionIC2;
import ic2.common.IC2DamageSource;
import ic2.common.IHasGui;
import ic2.common.Ic2Items;
import ic2.common.PositionSpec;
import ic2.common.TileEntityMachine;
import ic2.common.TileEntityReactorChamber;
import ic2.platform.AudioManager;
import ic2.platform.AudioSource;
import ic2.platform.NetworkManager;
import ic2.platform.Platform;
import java.util.List;
import java.util.Random;

public class TileEntityNuclearReactor
extends TileEntityMachine
implements IEnergySource,
IHasGui,
IReactor {
    public static Random randomizer = new Random();
    public short output = 0;
    public int updateTicker = randomizer.nextInt(this.tickRate());
    public int heat = 0;
    public boolean addedToEnergyNet = false;
    public AudioSource audioSourceMain;
    public AudioSource audioSourceGeiger;
    private short lastOutput = 0;

    public TileEntityNuclearReactor() {
        super(54);
    }

    public void h() {
        if (Platform.isSimulating() && this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.i).removeTileEntity(this);
            this.addedToEnergyNet = false;
        }
        if (Platform.isRendering()) {
            AudioManager.removeSources(this);
            this.audioSourceMain = null;
            this.audioSourceGeiger = null;
        }
        super.h();
    }

    @Override
    public String c() {
        return "Nuclear Reactor";
    }

    @Override
    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        try {
            this.heat = nbttagcompound.f("heat");
        }
        catch (Exception e) {
            this.heat = nbttagcompound.e("heat");
        }
        this.output = nbttagcompound.e("output");
    }

    @Override
    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("heat", this.heat);
        nbttagcompound.a("output", this.output);
    }

    @Override
    public void n_() {
        super.n_();
        if (!this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.i).addTileEntity(this);
            this.addedToEnergyNet = true;
        }
        this.sendEnergy(this.output);
        if (this.updateTicker++ % this.tickRate() != 0) {
            return;
        }
        if (!this.i.e(this.j, this.k, this.l, 2)) {
            this.output = 0;
        } else {
            this.dropAllUnfittingStuff();
            if (this.heat > 0) {
                this.heat -= this.coolReactorFromOutside();
                if (this.heat <= 0) {
                    this.heat = 0;
                } else if (this.calculateHeatEffects()) {
                    return;
                }
            }
            this.output = 0;
            this.processChambers();
            this.setActive(this.heat >= 1000 || this.output > 0);
            this.j();
        }
        NetworkManager.updateTileEntityField(this, "output");
    }

    public void dropAllUnfittingStuff() {
        short size = this.getReactorSize();
        for (short x = 0; x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                aan stack = this.getMatrixCoord(x, y);
                if (stack == null) continue;
                if (stack.a <= 0) {
                    this.setMatrixCoord(x, y, null);
                    continue;
                }
                if (x < size && TileEntityNuclearReactor.isUsefulItem(stack)) continue;
                this.eject(stack);
                this.setMatrixCoord(x, y, null);
            }
        }
    }

    public void eject(aan drop) {
        if (!Platform.isSimulating() || drop == null) {
            return;
        }
        float f = 0.7f;
        double d = (double)(this.i.r.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(this.i.r.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(this.i.r.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        fq entityitem = new fq(this.i, (double)this.j + d, (double)this.k + d1, (double)this.l + d2, drop);
        entityitem.c = 10;
        this.i.a((nn)entityitem);
    }

    public static boolean isUsefulItem(aan item) {
        if (item == null) {
            return false;
        }
        int id = item.c;
        return id == Ic2Items.uraniumCell.c || id == Ic2Items.coolingCell.c || id == Ic2Items.integratedReactorPlating.c || id == pb.aT.bO || id == yr.ax.bQ || id == yr.ay.bQ || id == yr.aw.bQ || id == Ic2Items.integratedHeatDisperser.c || id == Ic2Items.depletedIsotopeCell.c || id == Ic2Items.reEnrichedUraniumCell.c || id == Ic2Items.nearDepletedUraniumCell.c;
    }

    public int coolReactorFromOutside() {
        int cool = 1;
        int air = 0;
        for (int x = this.j - 1; x <= this.j + 1; ++x) {
            for (int y = this.k - 1; y <= this.k + 1; ++y) {
                for (int z = this.l - 1; z <= this.l + 1; ++z) {
                    if (this.i.a(x, y, z) == Ic2Items.reactorChamber.c) {
                        cool += 2;
                    }
                    if (this.i.f(x, y, z) == acn.g) {
                        ++cool;
                    }
                    if (this.i.a(x, y, z) == 0) {
                        ++air;
                    }
                    if (this.i.a(x, y, z) == pb.ar.bO) {
                        air -= 2;
                    }
                    if (this.i.f(x, y, z) != acn.h) continue;
                    cool -= 3;
                }
            }
        }
        if ((cool += air / 4) < 0) {
            return 0;
        }
        return cool;
    }

    public boolean calculateHeatEffects() {
        acn mat;
        int id;
        int[] coord;
        if (this.heat < 4000 || !Platform.isSimulating() || mod_IC2.explosionPowerReactorMax <= 0.0f) {
            return false;
        }
        int size = this.getReactorSize();
        int maxHeat = 10000;
        maxHeat += 1000 * (size - 3);
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < size; ++x) {
                if (this.getMatrixCoord(x, y) == null || this.getMatrixCoord((int)x, (int)y).c != Ic2Items.integratedReactorPlating.c) continue;
                maxHeat += 100;
            }
        }
        float power = (float)this.heat / (float)maxHeat;
        if (power >= 1.0f) {
            this.explode();
            return true;
        }
        if (power >= 0.85f && this.i.r.nextFloat() <= 4.0f * (power - 0.7f) && (coord = this.getRandCoord(2)) != null) {
            id = this.i.a(coord[0], coord[1], coord[2]);
            if (id == 0) {
                this.i.g(coord[0], coord[1], coord[2], pb.ar.bO);
            } else {
                mat = pb.m[id].cd;
                if (id != pb.z.bO) {
                    if (mat == acn.e || mat == acn.f || mat == acn.h || mat == acn.c || mat == acn.y) {
                        this.i.d(coord[0], coord[1], coord[2], pb.C.bO, 15);
                    } else {
                        this.i.g(coord[0], coord[1], coord[2], pb.ar.bO);
                    }
                }
            }
        }
        if (power >= 0.7f) {
            List list1 = this.i.a(acq.class, wu.a((double)(this.j - 3), (double)(this.k - 3), (double)(this.l - 3), (double)(this.j + 4), (double)(this.k + 4), (double)(this.l + 4)));
            for (int l = 0; l < list1.size(); ++l) {
                nn ent = (nn)list1.get(l);
                ent.a((md)IC2DamageSource.radiation, 1);
            }
        }
        if (power >= 0.5f && (coord = this.getRandCoord(2)) != null && (id = this.i.a(coord[0], coord[1], coord[2])) > 0 && pb.m[id].cd == acn.g) {
            this.i.g(coord[0], coord[1], coord[2], 0);
        }
        if (power >= 0.4f && this.i.r.nextFloat() <= 1.5f * (power - 0.4f) && (coord = this.getRandCoord(2)) != null && (id = this.i.a(coord[0], coord[1], coord[2])) > 0 && ((mat = pb.m[id].cd) == acn.d || mat == acn.i || mat == acn.m)) {
            this.i.g(coord[0], coord[1], coord[2], pb.ar.bO);
        }
        return false;
    }

    public int[] getRandCoord(int radius) {
        if (radius <= 0) {
            return null;
        }
        int[] c = new int[]{this.j + this.i.r.nextInt(2 * radius + 1) - radius, this.k + this.i.r.nextInt(2 * radius + 1) - radius, this.l + this.i.r.nextInt(2 * radius + 1) - radius};
        if (c[0] == this.j && c[1] == this.k && c[2] == this.l) {
            return null;
        }
        return c;
    }

    public void processChambers() {
        int size = this.getReactorSize();
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < size; ++x) {
                this.processChamber(x, y);
            }
        }
    }

    public void processChamber(int x, int y) {
        if (this.getMatrixCoord(x, y) == null) {
            return;
        }
        int id = this.getMatrixCoord((int)x, (int)y).c;
        if (id == Ic2Items.coolingCell.c && this.getMatrixCoord(x, y).i() > 0) {
            this.damageReactorItem(this.getMatrixCoord(x, y), -1);
        }
        if (id == Ic2Items.integratedReactorPlating.c && this.getMatrixCoord(x, y).i() > 0 && this.i.r.nextInt(10) == 0) {
            this.damageReactorItem(this.getMatrixCoord(x, y), -1);
        }
        if (id == Ic2Items.nearDepletedUraniumCell.c || id == Ic2Items.depletedIsotopeCell.c || id == Ic2Items.reEnrichedUraniumCell.c) {
            ++this.heat;
        }
        if (id == yr.ax.bQ && this.heat > 4000) {
            this.heat -= 250;
            this.getMatrixCoord((int)x, (int)y).c = yr.aw.bQ;
        }
        if (id == yr.ay.bQ) {
            this.heat += 2000;
            this.getMatrixCoord((int)x, (int)y).c = yr.aw.bQ;
        }
        if (id == pb.aT.bO && this.heat > 300) {
            this.heat -= 300;
            --this.getMatrixCoord((int)x, (int)y).a;
            if (this.getMatrixCoord((int)x, (int)y).a <= 0) {
                this.setMatrixCoord(x, y, null);
            }
        }
        if (id == Ic2Items.integratedHeatDisperser.c) {
            this.disperseHeat(x, y);
        }
        if (id == Ic2Items.uraniumCell.c && this.produceEnergy()) {
            this.generateEnergy(x, y);
        }
    }

    public void disperseHeat(int x, int y) {
        this.switchHeat(x, y, x - 1, y);
        this.switchHeat(x, y, x + 1, y);
        this.switchHeat(x, y, x, y - 1);
        this.switchHeat(x, y, x, y + 1);
        int rebalance = (this.getMatrixCoord(x, y).i() - this.heat + 1) / 2;
        if (rebalance > 0) {
            if (rebalance > 25) {
                rebalance = 25;
            }
            this.heat += rebalance;
            this.damageReactorItem(this.getMatrixCoord(x, y), -1 * rebalance);
        } else {
            if ((rebalance *= -1) > 25) {
                rebalance = 25;
            }
            this.heat -= rebalance;
            this.damageReactorItem(this.getMatrixCoord(x, y), rebalance);
        }
    }

    public void switchHeat(int x, int y, int x2, int y2) {
        int heat2;
        if (this.getMatrixCoord(x2, y2) == null) {
            return;
        }
        int id = this.getMatrixCoord((int)x2, (int)y2).c;
        if (id != Ic2Items.coolingCell.c && id != Ic2Items.integratedReactorPlating.c) {
            return;
        }
        int heat = this.getMatrixCoord(x, y).i();
        int rebalance = (heat - (heat2 = this.getMatrixCoord(x2, y2).i())) / 2;
        if (rebalance > 0) {
            if (rebalance > 6) {
                rebalance = 6;
            }
            this.getMatrixCoord(x, y).b(heat - rebalance);
            if (id == Ic2Items.coolingCell.c) {
                this.damageReactorItem(this.getMatrixCoord(x2, y2), rebalance);
            } else {
                this.spreadHeat(x2, y2, rebalance, false);
            }
        } else {
            if ((rebalance *= -1) > 6) {
                rebalance = 6;
            }
            this.damageReactorItem(this.getMatrixCoord(x, y), rebalance);
            this.getMatrixCoord(x2, y2).b(heat2 - rebalance);
        }
    }

    public void generateEnergy(int x, int y) {
        int pulses = 1 + this.isUranium(x + 1, y) + this.isUranium(x - 1, y) + this.isUranium(x, y + 1) + this.isUranium(x, y - 1);
        this.output = (short)(this.output + pulses * TileEntityNuclearReactor.pulsePower());
        pulses += this.enrichDepleted(x + 1, y) + this.enrichDepleted(x - 1, y) + this.enrichDepleted(x, y + 1) + this.enrichDepleted(x, y - 1);
        while (pulses > 0) {
            int genHeat;
            int takers = this.canTakeHeat(x + 1, y, true, true) + this.canTakeHeat(x - 1, y, true, true) + this.canTakeHeat(x, y + 1, true, true) + this.canTakeHeat(x, y - 1, true, true);
            switch (takers) {
                case 2: {
                    genHeat = 4;
                    break;
                }
                case 3: {
                    genHeat = 2;
                    break;
                }
                case 4: {
                    genHeat = 1;
                    break;
                }
                default: {
                    genHeat = 10;
                }
            }
            if (takers == 0) {
                this.heat += genHeat;
            } else {
                this.giveHeatTo(x + 1, y, genHeat);
                this.giveHeatTo(x - 1, y, genHeat);
                this.giveHeatTo(x, y + 1, genHeat);
                this.giveHeatTo(x, y - 1, genHeat);
            }
            --pulses;
        }
        if (this.getMatrixCoord(x, y).i() == 9999 && this.i.r.nextInt(3) == 0) {
            this.setMatrixCoord(x, y, Ic2Items.nearDepletedUraniumCell.k());
        } else {
            this.damageReactorItem(this.getMatrixCoord(x, y), 1);
        }
    }

    public int isUranium(int x, int y) {
        if (this.getMatrixCoord(x, y) != null && this.getMatrixCoord((int)x, (int)y).c == Ic2Items.uraniumCell.c) {
            return 1;
        }
        return 0;
    }

    public int enrichDepleted(int x, int y) {
        if (this.getMatrixCoord(x, y) == null || this.getMatrixCoord((int)x, (int)y).c != Ic2Items.depletedIsotopeCell.c) {
            return 0;
        }
        int oneInChance = 8;
        if (this.heat >= 3000) {
            oneInChance = 4;
        }
        if (this.heat >= 6000) {
            oneInChance = 2;
        }
        if (this.heat >= 9000) {
            oneInChance = 1;
        }
        if (this.i.r.nextInt(oneInChance) != 0) {
            return 1;
        }
        if (this.getMatrixCoord(x, y).i() <= 0) {
            this.setMatrixCoord(x, y, Ic2Items.reEnrichedUraniumCell.k());
        } else {
            this.damageReactorItem(this.getMatrixCoord(x, y), -2);
        }
        return 1;
    }

    public int canTakeHeat(int x, int y, boolean countPlating, boolean countCooler) {
        if (this.getMatrixCoord(x, y) == null) {
            return 0;
        }
        int id = this.getMatrixCoord((int)x, (int)y).c;
        if (id == Ic2Items.coolingCell.c || id == Ic2Items.integratedReactorPlating.c && countPlating || id == Ic2Items.integratedHeatDisperser.c && countCooler) {
            return 1;
        }
        return 0;
    }

    public void giveHeatTo(int x, int y, int heat) {
        if (this.canTakeHeat(x, y, true, true) == 0) {
            return;
        }
        if (this.getMatrixCoord((int)x, (int)y).c == Ic2Items.integratedReactorPlating.c) {
            this.spreadHeat(x, y, heat, true);
        } else {
            this.damageReactorItem(this.getMatrixCoord(x, y), heat);
        }
    }

    public void spreadHeat(int x, int y, int heat, boolean primary) {
        int genHeat;
        int takers = this.canTakeHeat(x + 1, y, primary, false) + this.canTakeHeat(x - 1, y, primary, false) + this.canTakeHeat(x, y + 1, primary, false) + this.canTakeHeat(x, y - 1, primary, false);
        if (takers == 0) {
            this.damageReactorItem(this.getMatrixCoord(x, y), heat);
            return;
        }
        while (heat % takers != 0 && this.getMatrixCoord(x, y).i() > 0) {
            ++heat;
            this.damageReactorItem(this.getMatrixCoord(x, y), -1);
        }
        if ((heat -= (genHeat = heat / takers) * takers) > 0) {
            this.damageReactorItem(this.getMatrixCoord(x, y), heat);
        }
        this.spreadHeatTo(x - 1, y, genHeat, primary);
        this.spreadHeatTo(x + 1, y, genHeat, primary);
        this.spreadHeatTo(x, y - 1, genHeat, primary);
        this.spreadHeatTo(x, y + 1, genHeat, primary);
    }

    public void spreadHeatTo(int x, int y, int heat, boolean toPlatings) {
        if (this.canTakeHeat(x, y, toPlatings, false) == 0) {
            return;
        }
        if (this.getMatrixCoord((int)x, (int)y).c == Ic2Items.integratedReactorPlating.c && toPlatings) {
            this.spreadHeat(x, y, heat, false);
        } else {
            this.damageReactorItem(this.getMatrixCoord(x, y), heat);
        }
    }

    public boolean produceEnergy() {
        return !this.i.x(this.j, this.k, this.l);
    }

    public aan getMatrixCoord(int x, int y) {
        if (x < 0 || x >= 9 || y < 0 || y >= 6) {
            return null;
        }
        return super.k_(x + y * 9);
    }

    public void damageReactorItem(aan itemStack, int damage) {
        if (!itemStack.e()) {
            return;
        }
        itemStack.b(itemStack.i() + damage);
        if (itemStack.i() > itemStack.j()) {
            --itemStack.a;
            if (itemStack.a < 0) {
                itemStack.a = 0;
            }
            itemStack.b(0);
        }
    }

    @Override
    public aan k_(int i) {
        int x = i % 9;
        short size = this.getReactorSize();
        if (x >= size) {
            return this.getMatrixCoord(size - 1, i / 9);
        }
        return super.k_(i);
    }

    public void setMatrixCoord(int x, int y, aan stack) {
        if (x < 0 || x >= 9 || y < 0 || y >= 6) {
            return;
        }
        super.a(x + y * 9, stack);
    }

    @Override
    public void a(int i, aan itemstack) {
        int x = i % 9;
        short size = this.getReactorSize();
        if (x >= size) {
            this.setMatrixCoord(size - 1, i / 9, itemstack);
        } else {
            super.a(i, itemstack);
        }
    }

    public short getReactorSize() {
        if (this.i == null) {
            return 9;
        }
        short rows = 3;
        for (Direction direction : Direction.values()) {
            kw target = direction.applyToTileEntity(this);
            if (!(target instanceof TileEntityReactorChamber)) continue;
            rows = (short)(rows + 1);
        }
        return rows;
    }

    public int tickRate() {
        return 20;
    }

    public static int pulsePower() {
        return mod_IC2.energyGeneratorNuclear;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean emitsEnergyTo(kw receiver, Direction direction) {
        return true;
    }

    @Override
    public int getMaxEnergyOutput() {
        return 240 * TileEntityNuclearReactor.pulsePower();
    }

    public int sendEnergy(int send) {
        send = EnergyNet.getForWorld(this.i).emitEnergyFrom(this, send);
        if (send > 0 && this.i.b(this.j, this.k + 1, this.l) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.i.b(this.j, this.k + 1, this.l)).sendEnergy(send);
        }
        if (send > 0 && this.i.b(this.j, this.k - 1, this.l) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.i.b(this.j, this.k - 1, this.l)).sendEnergy(send);
        }
        if (send > 0 && this.i.b(this.j + 1, this.k, this.l) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.i.b(this.j + 1, this.k, this.l)).sendEnergy(send);
        }
        if (send > 0 && this.i.b(this.j - 1, this.k, this.l) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.i.b(this.j - 1, this.k, this.l)).sendEnergy(send);
        }
        if (send > 0 && this.i.b(this.j, this.k, this.l + 1) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.i.b(this.j, this.k, this.l + 1)).sendEnergy(send);
        }
        if (send > 0 && this.i.b(this.j, this.k, this.l - 1) instanceof TileEntityReactorChamber) {
            send = ((TileEntityReactorChamber)this.i.b(this.j, this.k, this.l - 1)).sendEnergy(send);
        }
        return send;
    }

    @Override
    public ContainerIC2 getGuiContainer(yw entityPlayer) {
        return new ContainerNuclearReactor(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(yw entityPlayer) {
        return "GuiNuclearReactor";
    }

    @Override
    public void onGuiClosed(yw entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("output")) {
            if (this.output > 0) {
                if (this.lastOutput <= 0) {
                    if (this.audioSourceMain == null) {
                        this.audioSourceMain = AudioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/NuclearReactorLoop.ogg", true, false, AudioManager.defaultVolume);
                    }
                    if (this.audioSourceMain != null) {
                        this.audioSourceMain.play();
                    }
                }
                if (this.output < 40) {
                    if (this.lastOutput <= 0 || this.lastOutput >= 40) {
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.remove();
                        }
                        this.audioSourceGeiger = AudioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerLowEU.ogg", true, false, AudioManager.defaultVolume);
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.play();
                        }
                    }
                } else if (this.output < 80) {
                    if (this.lastOutput < 40 || this.lastOutput >= 80) {
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.remove();
                        }
                        this.audioSourceGeiger = AudioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerMedEU.ogg", true, false, AudioManager.defaultVolume);
                        if (this.audioSourceGeiger != null) {
                            this.audioSourceGeiger.play();
                        }
                    }
                } else if (this.output >= 80 && this.lastOutput < 80) {
                    if (this.audioSourceGeiger != null) {
                        this.audioSourceGeiger.remove();
                    }
                    this.audioSourceGeiger = AudioManager.createSource(this, PositionSpec.Center, "Generators/NuclearReactor/GeigerHighEU.ogg", true, false, AudioManager.defaultVolume);
                    if (this.audioSourceGeiger != null) {
                        this.audioSourceGeiger.play();
                    }
                }
            } else if (this.lastOutput > 0) {
                if (this.audioSourceMain != null) {
                    this.audioSourceMain.stop();
                }
                if (this.audioSourceGeiger != null) {
                    this.audioSourceGeiger.stop();
                }
            }
            this.lastOutput = this.output;
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }

    @Override
    public uh getPosition() {
        return new uh(this.j, this.k, this.l);
    }

    @Override
    public xd getWorld() {
        return this.i;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(int heat) {
        this.heat = heat;
    }

    @Override
    public int addHeat(int amount) {
        this.heat += amount;
        return this.heat;
    }

    @Override
    public aan getItemAt(int x, int y) {
        return this.getMatrixCoord(x, y);
    }

    @Override
    public void setItemAt(int x, int y, aan item) {
        this.setMatrixCoord(x, y, item);
    }

    @Override
    public void explode() {
        float boomPower = 10.0f;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < this.getReactorSize(); ++x) {
                if (this.getMatrixCoord(x, y) != null && this.getMatrixCoord((int)x, (int)y).c == Ic2Items.uraniumCell.c) {
                    boomPower += 3.0f;
                    continue;
                }
                if (this.getMatrixCoord(x, y) == null || this.getMatrixCoord((int)x, (int)y).c != Ic2Items.integratedReactorPlating.c) continue;
                boomPower -= 1.0f;
            }
        }
        if (boomPower > mod_IC2.explosionPowerReactorMax) {
            boomPower = mod_IC2.explosionPowerReactorMax;
        }
        this.i.g(this.j, this.k, this.l, 0);
        ExplosionIC2 explosion = new ExplosionIC2(this.i, null, this.j, this.k, this.l, boomPower, 0.01f, 1.5f, IC2DamageSource.nuke);
        explosion.doExplosion();
    }
}

