/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.Direction;
import ic2.api.INetworkTileEntityEventListener;
import ic2.common.AudioPosition;
import ic2.common.IC2Achievements;
import ic2.common.Ic2Items;
import ic2.common.PositionSpec;
import ic2.common.TileEntityBlock;
import ic2.common.TileEntityElectricBlock;
import ic2.platform.AudioManager;
import ic2.platform.AudioSource;
import ic2.platform.NetworkManager;
import ic2.platform.Platform;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class TileEntityTeleporter
extends TileEntityBlock
implements INetworkTileEntityEventListener {
    public boolean targetSet = false;
    public int targetX;
    public int targetY;
    public int targetZ;
    private AudioSource audioSource = null;
    private static final int EventTeleport = 0;

    @Override
    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        this.targetSet = nbttagcompound.o("targetSet");
        this.targetX = nbttagcompound.f("targetX");
        this.targetY = nbttagcompound.f("targetY");
        this.targetZ = nbttagcompound.f("targetZ");
    }

    @Override
    public void b(ady nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("targetSet", this.targetSet);
        nbttagcompound.a("targetX", this.targetX);
        nbttagcompound.a("targetY", this.targetY);
        nbttagcompound.a("targetZ", this.targetZ);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void n_() {
        super.n_();
        if (Platform.isSimulating()) {
            if (this.i.x(this.j, this.k, this.l) && this.targetSet) {
                ack chunk = Platform.getOrLoadChunk(this.i, this.targetX >> 4, this.targetZ >> 4);
                if (chunk == null || chunk.a(this.targetX & 0xF, this.targetY, this.targetZ & 0xF) != Ic2Items.teleporter.c || chunk.c(this.targetX & 0xF, this.targetY, this.targetZ & 0xF) != Ic2Items.teleporter.i()) {
                    this.targetSet = false;
                    this.setActive(false);
                } else {
                    this.setActive(true);
                    List entitiesNearby = this.i.a(nn.class, wu.a((double)(this.j - 1), (double)this.k, (double)(this.l - 1), (double)(this.j + 2), (double)(this.k + 3), (double)(this.l + 2)));
                    if (!entitiesNearby.isEmpty()) {
                        double minDistanceSquared = Double.MAX_VALUE;
                        nn closestEntity = null;
                        for (nn entity : entitiesNearby) {
                            double distSquared;
                            if (entity.j != null || !((distSquared = ((double)this.j - entity.o) * ((double)this.j - entity.o) + ((double)(this.k + 1) - entity.p) * ((double)(this.k + 1) - entity.p) + ((double)this.l - entity.q) * ((double)this.l - entity.q)) < minDistanceSquared)) continue;
                            minDistanceSquared = distSquared;
                            closestEntity = entity;
                        }
                        this.teleport(closestEntity);
                    }
                }
            } else {
                this.setActive(false);
            }
        }
        if (Platform.isRendering() && this.getActive()) {
            this.spawnBlueParticles(2, this.j, this.k, this.l);
        }
    }

    public void h() {
        if (Platform.isRendering() && this.audioSource != null) {
            AudioManager.removeSources(this);
            this.audioSource = null;
        }
        super.h();
    }

    public void teleport(nn user) {
        double distance = Math.sqrt((this.j - this.targetX) * (this.j - this.targetX) + (this.k - this.targetY) * (this.k - this.targetY) + (this.l - this.targetZ) * (this.l - this.targetZ));
        int weight = this.getWeightOf(user);
        if (weight == 0) {
            return;
        }
        int energyCost = (int)((double)weight * Math.pow(distance + 10.0, 0.7) * 5.0);
        if (energyCost > this.getAvailableEnergy()) {
            return;
        }
        this.consumeEnergy(energyCost);
        Platform.teleportTo(user, (double)this.targetX + 0.5, (double)this.targetY + 1.5 + user.P(), (double)this.targetZ + 0.5, user.u, user.v);
        NetworkManager.initiateTileEntityEvent(this, 0, true);
        if (user instanceof yw && distance >= 1000.0) {
            IC2Achievements.issueAchievement((yw)user, "teleportFarAway");
        }
    }

    public void spawnBlueParticles(int n, int x, int y, int z) {
        for (int i = 0; i < n; ++i) {
            this.i.a("reddust", (double)((float)x + this.i.r.nextFloat()), (double)((float)(y + 1) + this.i.r.nextFloat()), (double)((float)z + this.i.r.nextFloat()), -1.0, 0.0, 1.0);
            this.i.a("reddust", (double)((float)x + this.i.r.nextFloat()), (double)((float)(y + 2) + this.i.r.nextFloat()), (double)((float)z + this.i.r.nextFloat()), -1.0, 0.0, 1.0);
        }
    }

    public void consumeEnergy(int energy) {
        LinkedList<TileEntityElectricBlock> energySources = new LinkedList<TileEntityElectricBlock>();
        for (Direction direction : Direction.values()) {
            kw target = direction.applyToTileEntity(this);
            if (!(target instanceof TileEntityElectricBlock)) continue;
            TileEntityElectricBlock energySource = (TileEntityElectricBlock)target;
            if (energySource.energy <= 0) continue;
            energySources.add(energySource);
        }
        while (energy > 0) {
            int drain = (energy + energySources.size() - 1) / energySources.size();
            Iterator it = energySources.iterator();
            while (it.hasNext()) {
                TileEntityElectricBlock energySource = (TileEntityElectricBlock)it.next();
                if (drain > energy) {
                    drain = energy;
                }
                if (energySource.energy <= drain) {
                    energy -= energySource.energy;
                    energySource.energy = 0;
                    it.remove();
                    continue;
                }
                energy -= drain;
                energySource.energy -= drain;
            }
        }
    }

    public int getAvailableEnergy() {
        int energy = 0;
        for (Direction direction : Direction.values()) {
            kw target = direction.applyToTileEntity(this);
            if (!(target instanceof TileEntityElectricBlock)) continue;
            energy += ((TileEntityElectricBlock)target).energy;
        }
        return energy;
    }

    public int getWeightOf(nn user) {
        int weight = 0;
        nn ce = user;
        while (ce != null) {
            if (ce instanceof fq) {
                aan is = ((fq)ce).a;
                weight += 100 * is.a / is.c();
            } else if (ce instanceof bc || ce instanceof ama || ce instanceof ep) {
                weight += 100;
            } else if (ce instanceof yw) {
                weight += 1000;
                if (mod_IC2.enableTeleporterInventory) {
                    int i;
                    aak inv = ((yw)ce).ap;
                    for (i = 0; i < inv.a.length; ++i) {
                        if (inv.a[i] == null) continue;
                        weight += 100 * inv.a[i].a / inv.a[i].c();
                    }
                    for (i = 0; i < inv.b.length; ++i) {
                        if (inv.b[i] == null) continue;
                        weight += 100;
                    }
                }
            } else if (ce instanceof ui) {
                weight += 2500;
            } else if (ce instanceof oq) {
                weight += 10000;
            } else if (ce instanceof aaa) {
                weight += 500;
            }
            ce = ce.i;
        }
        return weight;
    }

    public void setTarget(int x, int y, int z) {
        this.targetSet = true;
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        NetworkManager.updateTileEntityField(this, "targetX");
        NetworkManager.updateTileEntityField(this, "targetY");
        NetworkManager.updateTileEntityField(this, "targetZ");
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(3);
        ret.add("targetX");
        ret.add("targetY");
        ret.add("targetZ");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = AudioManager.createSource(this, PositionSpec.Center, "Machines/Teleporter/TeleChargedLoop.ogg", true, false, AudioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                AudioManager.playOnce(this, PositionSpec.Center, "Machines/Teleporter/TeleUse.ogg", true, AudioManager.defaultVolume);
                AudioManager.playOnce(new AudioPosition(this.i, (float)this.targetX + 0.5f, (float)this.targetY + 0.5f, (float)this.targetZ + 0.5f), PositionSpec.Center, "Machines/Teleporter/TeleUse.ogg", true, AudioManager.defaultVolume);
                this.spawnBlueParticles(20, this.j, this.k, this.l);
                this.spawnBlueParticles(20, this.targetX, this.targetY, this.targetZ);
                break;
            }
            default: {
                Platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\n" + "T: " + this + " (" + this.j + "," + this.k + "," + this.l + ")");
            }
        }
    }
}

