package net.minecraft.src.ic2.advancedmachines;

import java.util.*;
import net.minecraft.src.*;
import net.minecraft.src.forge.*;
import net.minecraft.src.ic2.api.*;

public class TileEntityCentrifugeExtractor extends TileEntityAdvancedMachine
{
    public Container getGuiContainer(InventoryPlayer var1)
    {
        return new ContainerCentrifugeExtractor(var1, this);
    }

    public TileEntityCentrifugeExtractor()
    {
        super("Centrifuge Extractor", "%5d M/S", 1, new int[] {0}, new int[] {2, 3, 4});
    }

    protected List getResultMap()
    {
        return Ic2Recipes.getExtractorRecipes();
    }

    public ItemStack getResultFor(ItemStack var1, boolean var2)
    {
        return Ic2Recipes.getExtractorOutputFor(var1, var2);
    }
    
    public String getStartSoundFile()
    {
    	return mod_IC2AdvancedMachines.advExtcSound;
    }

    public String getInterruptSoundFile()
    {
    	return mod_IC2AdvancedMachines.interruptSound;
    }
}
