package net.minecraft.src;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.src.forge.*;
import net.minecraft.src.ic2.advancedmachines.*;
import net.minecraft.src.ic2.api.*;

public class mod_IC2AdvancedMachines extends NetworkMod implements IGuiHandler
{
	@Override
    public String getVersion()
    {
        return "v4.1";
    }
	
	public static mod_IC2AdvancedMachines instance;
	
    public static Configuration config;
    
    public static Block blockAdvancedMachine;

    public static int guiIdRotary;
    public static int guiIdSingularity;
    public static int guiIdCentrifuge;
    
    public static String advMaceSound = "Machines/MaceratorOp.ogg";
    public static String advCompSound = "Machines/CompressorOp.ogg";
    public static String advExtcSound = "Machines/ExtractorOp.ogg";
    
    public static String interruptSound = "Machines/InterruptOne.ogg";
    
    public static String advMaceName = "Rotary Macerator";
    public static String advCompName = "Singularity Compressor";
    public static String advExtcName = "Centrifuge Extractor";
    
    public static int[][] sideAndFacingToSpriteOffset;
    
    public static ItemStack overClockerStack;
    public static ItemStack transformerStack;
    public static ItemStack energyStorageUpgradeStack;
    
    public static final Item refinedIronDust = new Item(29775).setItemName("Refined Iron Dust"); 
    
	@Override
	public Object getGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
	{
		TileEntity te = world.getBlockTileEntity(x, y, z);
		
		if (te != null)
		{
			if (te instanceof TileEntityRotaryMacerator)
			{
				return new GuiRotaryMacerator(player.inventory, (TileEntityRotaryMacerator) te);
			}
			else if (te instanceof TileEntityCentrifugeExtractor)
			{
				return new GuiCentrifugeExtractor(player.inventory, (TileEntityCentrifugeExtractor) te);
			}
			else if (te instanceof TileEntitySingularityCompressor)
			{
				return new GuiSingularityCompressor(player.inventory, (TileEntitySingularityCompressor) te);
			}
		}
		
		return null;
	}

    public static int getConfigInt(String stringValue, int defaultValue, String category, boolean useComment, String comment)
    {
        if (config == null)
        {
            return defaultValue;
        } else
        {
            try
            {
            	if(useComment)
            	{
            		Property prop = config.getOrCreateIntProperty(stringValue, category, defaultValue);
            		prop.comment = comment;
            		return Integer.valueOf(prop.value).intValue();
            	}
                return Integer.valueOf(config.getOrCreateIntProperty(stringValue, category, defaultValue).value).intValue();
            }
            catch (Exception var3)
            {
                System.out.println("[Advanced Machines] Error while trying to access config, wasn\'t loaded properly!");
                return defaultValue;
            }
        }
    }
    
    public static int getBlockId(String stringValue, int defaultValue)
    {
        if (config == null)
        {
            return defaultValue;
        } else
        {
            try
            {
                return Integer.valueOf(config.getOrCreateBlockIdProperty(stringValue, defaultValue).value).intValue();
            }
            catch (Exception var3)
            {
                System.out.println("[Advanced Machines] Error while trying to access config, wasn\'t loaded properly!");
                return defaultValue;
            }
        }
    }
    
    @Override
    public String getPriorities()	//								//
    {								//			IMPORTANT			//
    	return "after:mod_IC2";		//		 ALWAYS USE THIS		//
    }								//								//

    @Override
    public void load()
    {
    	instance = this;
    	
    	try
    	{
    		sideAndFacingToSpriteOffset = (int[][])Class.forName("ic2.common.BlockMultiID").getField("sideAndFacingToSpriteOffset").get(null);
    	} catch (Exception e)
    	{
    		sideAndFacingToSpriteOffset = new int[][]{
    				{
    		            3, 2, 0, 0, 0, 0
    		        }, {
    		            2, 3, 1, 1, 1, 1
    		        }, {
    		            1, 1, 3, 2, 5, 4
    		        }, {
    		            0, 0, 2, 3, 4, 5
    		        }, {
    		            4, 5, 4, 5, 3, 2
    		        }, {
    		            5, 4, 5, 4, 2, 3
    		        }
    		    };
    	}
    	try
        {
            config = new Configuration(new File(Minecraft.getMinecraftDir().getPath(), "/config/IC2AdvancedMachine.cfg"));
            config.load();
        }
        catch (Exception var2)
        {
            System.out.println("[Advanced Machines] Error while trying to access configuration: "+var2);
            config = null;
        }

        blockAdvancedMachine = new BlockAdvancedMachines(getBlockId("blockAdvancedMachine", 188));

        guiIdRotary = getConfigInt("guiIdRotary", 40, Configuration.CATEGORY_GENERAL, false, "");
        guiIdSingularity = getConfigInt("guiIdSingularity", 41, Configuration.CATEGORY_GENERAL, false, "");
        guiIdCentrifuge = getConfigInt("guiIdCentrifuge", 42, Configuration.CATEGORY_GENERAL, true, "GUI IDs. Only change them if you got a conflict.");
                
        if (config != null)
        {
            Property  prop = config.getOrCreateProperty("advCompressorSound", Configuration.CATEGORY_GENERAL, advCompSound);
            prop.comment = "Sound files to use on operation. Remember to use '/' instead of backslashes and the Sound directory starts on ic2/sounds. Set to null to not use any sound.";
            advCompSound = prop.value;
            advExtcSound = config.getOrCreateProperty("advExtractorSound", Configuration.CATEGORY_GENERAL, advExtcSound).value;
            advMaceSound = config.getOrCreateProperty("advMaceratorSound", Configuration.CATEGORY_GENERAL, advMaceSound).value;
            
            prop = config.getOrCreateProperty("nameAdvCompressor", Configuration.CATEGORY_GENERAL, advCompName);
            prop.comment = "Item names. This will also affect their GUI";
            advCompName = prop.value;
            advExtcName = config.getOrCreateProperty("nameAdvExtractor", Configuration.CATEGORY_GENERAL, advExtcName).value;
            advMaceName = config.getOrCreateProperty("nameAdvMacerator", Configuration.CATEGORY_GENERAL, advMaceName).value;
            
            prop = config.getOrCreateProperty("interuptSound", Configuration.CATEGORY_GENERAL, interruptSound);
            prop.comment = "Interupt sound file";
        	
            config.save();
        }

        ModLoader.registerBlock(blockAdvancedMachine, ItemAdvancedMachine.class);
    	
    	ModLoader.addLocalization("blockRotaryMacerator.name", advMaceName);
        ModLoader.addLocalization("blockSingularityCompressor.name", advCompName);
        ModLoader.addLocalization("blockCentrifugeExtractor.name", advExtcName);

        ModLoader.registerTileEntity(TileEntityRotaryMacerator.class, "Rotary Macerator");
        ModLoader.registerTileEntity(TileEntitySingularityCompressor.class, "Singularity Compressor");
        ModLoader.registerTileEntity(TileEntityCentrifugeExtractor.class, "Centrifuge Extractor");

        /*
        ModLoaderMp.registerGUI(this, guiIdRotary);
        ModLoaderMp.registerGUI(this, guiIdSingularity);
        ModLoaderMp.registerGUI(this, guiIdCentrifuge);
        */
        
        MinecraftForge.setGuiHandler(this, this);
        
        MinecraftForgeClient.preloadTexture("ic2/sprites/block_advmachine.png");
        MinecraftForgeClient.preloadTexture("ic2/sprites/refinedIronDust.png");
    }
    
    @Override
    public void modsLoaded()
    {
        Ic2Recipes.addCraftingRecipe(new ItemStack(blockAdvancedMachine, 1, 0),
        		new Object[] {"RRR", "RMR", "RAR",
        	Character.valueOf('R'), Items.getItem("refinedIronIngot"),
        	Character.valueOf('M'), Items.getItem("macerator"),
        	Character.valueOf('A'), Items.getItem("advancedMachine")});
        
        Ic2Recipes.addCraftingRecipe(new ItemStack(blockAdvancedMachine, 1, 1),
        		new Object[] {"RRR", "RMR", "RAR",
        	Character.valueOf('R'), Block.obsidian,
        	Character.valueOf('M'), Items.getItem("compressor"),
        	Character.valueOf('A'), Items.getItem("advancedMachine")});
        
        Ic2Recipes.addCraftingRecipe(new ItemStack(blockAdvancedMachine, 1, 2),
        		new Object[] {"RRR", "RMR", "RAR",
        	Character.valueOf('R'), Items.getItem("electrolyzedWaterCell"),
        	Character.valueOf('M'), Items.getItem("extractor"),
        	Character.valueOf('A'), Items.getItem("advancedMachine")});
        
        overClockerStack = Items.getItem("overclockerUpgrade");
        transformerStack = Items.getItem("transformerUpgrade");
        energyStorageUpgradeStack = Items.getItem("energyStorageUpgrade");
        
        refinedIronDust.iconIndex = ModLoader.addOverride("/gui/items.png", "/ic2/sprites/refinedIronDust.png");
        ModLoader.addName(refinedIronDust, "Refined Iron Dust");
        ModLoader.addSmelting(refinedIronDust.shiftedIndex, Items.getItem("refinedIronIngot"));
    }
    
    public static boolean explodeMachineAt(World world, int x, int y, int z)
    {
		try 
		{
			Class<?> mainIC2Class = Class.forName("mod_IC2");
			mainIC2Class.getMethod("explodeMachineAt", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(null, world, x, y, z);
			return true;
		}
		catch (Exception e) 
		{
			return false;
		}
    }
}
