package net.minecraft.src;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.src.forge.*;
import net.minecraft.src.ic2.advancedmachines.*;
import net.minecraft.src.ic2.api.*;

public class mod_IC2AdvancedMachines extends NetworkMod implements IGuiHandler
{
	@Override
    public String getVersion()
    {
        return "v4.1";
    }
	
	public static mod_IC2AdvancedMachines instance;
	
    public static Configuration config;
    
    public static Block blockAdvancedMachine;

    public static int guiIdRotary;
    public static int guiIdSingularity;
    public static int guiIdCentrifuge;
    
    public static String advMaceName = "Rotary Macerator";
    public static String advCompName = "Singularity Compressor";
    public static String advExtcName = "Centrifuge Extractor";
    
    public static ItemStack overClockerStack;
    public static ItemStack transformerStack;
    public static ItemStack energyStorageUpgradeStack;

	public static String advMaceSound = null;
	public static String interruptSound = null;
    
    public static final Item refinedIronDust = new Item(29775).setItemName("Refined Iron Dust");

    public static int getConfigInt(String stringValue, int defaultValue, String category, boolean useComment, String comment)
    {
        if (config == null)
        {
            return defaultValue;
        } else
        {
            try
            {
            	if(useComment)
            	{
            		Property prop = config.getOrCreateIntProperty(stringValue, category, defaultValue);
            		prop.comment = comment;
            		return Integer.valueOf(prop.value).intValue();
            	}
                return Integer.valueOf(config.getOrCreateIntProperty(stringValue, category, defaultValue).value).intValue();
            }
            catch (Exception var3)
            {
                System.out.println("[Advanced Machines] Error while trying to access config, wasn\'t loaded properly!");
                return defaultValue;
            }
        }
    }
    
    public static int getBlockId(String stringValue, int defaultValue)
    {
        if (config == null)
        {
            return defaultValue;
        } else
        {
            try
            {
                return Integer.valueOf(config.getOrCreateBlockIdProperty(stringValue, defaultValue).value).intValue();
            }
            catch (Exception var3)
            {
                System.out.println("[Advanced Machines] Error while trying to access config, wasn\'t loaded properly!");
                return defaultValue;
            }
        }
    }
    
	@Override
	public Object getGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
	{
		TileEntity te = world.getBlockTileEntity(x, y, z);
		
		if (te != null)
		{
			if (te instanceof TileEntityRotaryMacerator)
			{
				return ((TileEntityRotaryMacerator)te).getGuiContainer(player.inventory);
			}
			else if (te instanceof TileEntityCentrifugeExtractor)
			{
				return ((TileEntityCentrifugeExtractor)te).getGuiContainer(player.inventory);
			}
			else if (te instanceof TileEntitySingularityCompressor)
			{
				return ((TileEntitySingularityCompressor)te).getGuiContainer(player.inventory);
			}
		}
		
		return null;
	}

	/*
    public static void showGui(EntityPlayer player, int guiID, TileEntity tileEnt)
    {
    	ModLoader.openGUI(player, guiID, player.inventory, ((TileEntityAdvancedMachine)tileEnt).getGuiContainer(player.inventory));
    }
    */
    
    //////////////////////////////////////////////////////////////////
    @Override
    public String getPriorities()	//								//
    {								//			IMPORTANT			//
    	return "after:mod_IC2";		//		 ALWAYS USE THIS		//
    }								//								//
    //////////////////////////////////////////////////////////////////
    @Override
    public void load()
    {
    	instance = this;
    	try
        {
    		config = new Configuration(new File((new File(".")).getPath(), "/config/IC2AdvancedMachine.cfg"));
            config.load();
        }
        catch (Exception var2)
        {
            System.out.println("[Advanced Machines] Error while trying to access configuration!");
            config = null;
        }

        blockAdvancedMachine = new BlockAdvancedMachines(getBlockId("blockAdvancedMachine", 188));

        guiIdRotary = getConfigInt("guiIdRotary", 40, Configuration.CATEGORY_GENERAL, false, "");
        guiIdSingularity = getConfigInt("guiIdSingularity", 41, Configuration.CATEGORY_GENERAL, false, "");
        guiIdCentrifuge = getConfigInt("guiIdCentrifuge", 42, Configuration.CATEGORY_GENERAL, true, "GUI IDs. Only change them if you got a conflict.");
        
        if (config != null)
        {
            config.save();
        }

        ModLoader.registerBlock(blockAdvancedMachine, ItemAdvancedMachine.class);

        ModLoader.registerTileEntity(TileEntityRotaryMacerator.class, "Rotary Macerator");
        ModLoader.registerTileEntity(TileEntitySingularityCompressor.class, "Singularity Compressor");
        ModLoader.registerTileEntity(TileEntityCentrifugeExtractor.class, "Centrifuge Extractor");
        
        MinecraftForge.setGuiHandler(this, this);
    }
    
    @Override
    public void modsLoaded()
    {
        Ic2Recipes.addCraftingRecipe(new ItemStack(blockAdvancedMachine, 1, 0),
        		new Object[] {"RRR", "RMR", "RAR",
        	Character.valueOf('R'), Items.getItem("refinedIronIngot"),
        	Character.valueOf('M'), Items.getItem("macerator"),
        	Character.valueOf('A'), Items.getItem("advancedMachine")});
        
        Ic2Recipes.addCraftingRecipe(new ItemStack(blockAdvancedMachine, 1, 1),
        		new Object[] {"RRR", "RMR", "RAR",
        	Character.valueOf('R'), Block.obsidian,
        	Character.valueOf('M'), Items.getItem("compressor"),
        	Character.valueOf('A'), Items.getItem("advancedMachine")});
        
        Ic2Recipes.addCraftingRecipe(new ItemStack(blockAdvancedMachine, 1, 2),
        		new Object[] {"RRR", "RMR", "RAR",
        	Character.valueOf('R'), Items.getItem("electrolyzedWaterCell"),
        	Character.valueOf('M'), Items.getItem("extractor"),
        	Character.valueOf('A'), Items.getItem("advancedMachine")});
        
        overClockerStack = Items.getItem("overclockerUpgrade");
        transformerStack = Items.getItem("transformerUpgrade");
        energyStorageUpgradeStack = Items.getItem("energyStorageUpgrade");
        
        refinedIronDust.iconIndex = ModLoader.addOverride("/gui/items.png", "ic2/sprites/refinedIronDust.png");
        ModLoader.addSmelting(refinedIronDust.shiftedIndex, Items.getItem("refinedIronIngot"));
    }
    
    public static boolean explodeMachineAt(World world, int x, int y, int z)
    {
		try 
		{
			Class<?> mainIC2Class = Class.forName("mod_IC2");
			mainIC2Class.getMethod("explodeMachineAt", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(null, world, x, y, z);
			return true;
		}
		catch (Exception e) 
		{
			return false;
		}
    }
}
